/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.BasketBlock;
import vectorwing.farmersdelight.common.block.entity.Basket;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BasketBlockEntity
extends RandomizableContainerBlockEntity
implements Basket {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private int transferCooldown = -1;

    public BasketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BASKET.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
        this.transferCooldown = compound.getInt("TransferCooldown");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
        compound.putInt("TransferCooldown", this.transferCooldown);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), (int)index, (int)count);
    }

    public void setItem(int index, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    protected Component getDefaultName() {
        return TextUtils.getTranslation("container.basket", new Object[0]);
    }

    public static boolean pullItems(Level level, Basket basket, int facingIndex) {
        for (ItemEntity itementity : BasketBlockEntity.getCaptureItems(level, basket, facingIndex)) {
            if (!BasketBlockEntity.captureItem(basket, itementity)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack putStackInInventoryAllSlots(Container destination, ItemStack stack) {
        int i = destination.getContainerSize();
        for (int j = 0; j < i && !stack.isEmpty(); ++j) {
            stack = BasketBlockEntity.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.canPlaceItem(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).canPlaceItemThroughFace(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    private static ItemStack insertStack(Container destination, ItemStack stack, int index) {
        ItemStack itemstack = destination.getItem(index);
        if (BasketBlockEntity.canInsertItemInSlot(destination, stack, index, null)) {
            boolean flag = false;
            boolean isDestinationEmpty = destination.isEmpty();
            if (itemstack.isEmpty()) {
                destination.setItem(index, stack);
                stack = ItemStack.EMPTY;
                flag = true;
            } else if (BasketBlockEntity.canCombine(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                BasketBlockEntity firstBasket;
                if (isDestinationEmpty && destination instanceof BasketBlockEntity && !(firstBasket = (BasketBlockEntity)destination).mayTransfer()) {
                    int k = 0;
                    firstBasket.setTransferCooldown(8 - k);
                }
                destination.setChanged();
            }
        }
        return stack;
    }

    public static boolean captureItem(Container inventory, ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack entityItemStack = itemEntity.getItem().copy();
        ItemStack remainderStack = BasketBlockEntity.putStackInInventoryAllSlots(inventory, entityItemStack);
        if (remainderStack.isEmpty()) {
            flag = true;
            itemEntity.discard();
        } else {
            itemEntity.setItem(remainderStack);
        }
        return flag;
    }

    public static List<ItemEntity> getCaptureItems(Level level, Basket basket, int facingIndex) {
        return basket.getFacingCollectionArea(facingIndex).toAabbs().stream().flatMap(aabb -> level.getEntitiesOfClass(ItemEntity.class, aabb.move(basket.getLevelX() - 0.5, basket.getLevelY() - 0.5, basket.getLevelZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    private void updateHopper(Supplier<Boolean> supplier) {
        if (this.level != null && !this.level.isClientSide && !this.isOnTransferCooldown() && ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = supplier.get();
            }
            if (flag) {
                this.setTransferCooldown(8);
                this.setChanged();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos blockpos = this.getBlockPos();
            int facing = ((Direction)this.getBlockState().getValue((Property)BasketBlock.FACING)).get3DDataValue();
            if (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-blockpos.getX()), (double)(-blockpos.getY()), (double)(-blockpos.getZ()))), (VoxelShape)this.getFacingCollectionArea(facing), (BooleanOp)BooleanOp.AND)) {
                this.updateHopper(() -> BasketBlockEntity.captureItem(this, (ItemEntity)entity));
            }
        }
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, BasketBlockEntity blockEntity) {
        --blockEntity.transferCooldown;
        if (!blockEntity.isOnTransferCooldown()) {
            blockEntity.setTransferCooldown(0);
            int facing = ((Direction)state.getValue((Property)BasketBlock.FACING)).get3DDataValue();
            blockEntity.updateHopper(() -> BasketBlockEntity.pullItems(level, blockEntity, facing));
        }
    }
}

