/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item.enchantment;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.commons.lang3.mutable.MutableFloat;
import vectorwing.farmersdelight.common.registry.ModDataComponents;

public class BackstabbingEnchantment {
    public static boolean isLookingBehindTarget(LivingEntity target, Vec3 attackerLocation) {
        if (attackerLocation != null) {
            Vec3 lookingVector = target.getViewVector(1.0f);
            Vec3 attackAngleVector = attackerLocation.subtract(target.position()).normalize();
            attackAngleVector = new Vec3(attackAngleVector.x, 0.0, attackAngleVector.z);
            return attackAngleVector.dot(lookingVector) < -0.5;
        }
        return false;
    }

    public static float getBackstabbingDamagePerLevel(float amount, int level) {
        float multiplier = (float)level * 0.2f + 1.2f;
        return amount * multiplier;
    }

    @EventBusSubscriber(modid="farmersdelight", bus=EventBusSubscriber.Bus.GAME)
    public static class BackstabbingEvent {
        @SubscribeEvent
        public static void onKnifeBackstab(LivingIncomingDamageEvent event) {
            Entity attacker = event.getSource().getEntity();
            if (attacker instanceof LivingEntity) {
                Level level;
                LivingEntity living = (LivingEntity)attacker;
                if (BackstabbingEnchantment.isLookingBehindTarget(event.getEntity(), event.getSource().getSourcePosition()) && (level = attacker.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemStack weapon = living.getWeaponItem();
                    float preModifiedDamage = event.getAmount();
                    MutableFloat dmg = new MutableFloat(event.getAmount());
                    EnchantmentHelper.runIterationOnItem((ItemStack)weapon, (enchantment, powerLevel) -> ((Enchantment)enchantment.value()).modifyDamageFilteredValue((DataComponentType)ModDataComponents.BACKSTABBING.get(), serverLevel, powerLevel, weapon, attacker, event.getSource(), dmg));
                    if (preModifiedDamage != dmg.getValue().floatValue()) {
                        event.setAmount(dmg.getValue().floatValue());
                        serverLevel.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

