/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.renderer.shaders.FadeApplyShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.FadeShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class FadeRenderer {
    public static FadeRenderer INSTANCE = new FadeRenderer();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private boolean init = false;
    private int width = -1;
    private int height = -1;
    private int fadeFramebuffer = -1;
    private int fadeTexture = -1;

    private FadeRenderer() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        FadeShader.INSTANCE.init();
        FadeApplyShader.INSTANCE.init();
    }

    private void createFramebuffer(int width, int height) {
        if (this.fadeFramebuffer != -1) {
            GL32.glDeleteFramebuffers((int)this.fadeFramebuffer);
            this.fadeFramebuffer = -1;
        }
        this.fadeFramebuffer = GL32.glGenFramebuffers();
        GLMC.glBindFramebuffer(36160, this.fadeFramebuffer);
        if (MC_RENDER.mcRendersToFrameBuffer()) {
            if (this.fadeTexture != -1) {
                GLMC.glDeleteTextures(this.fadeTexture);
                this.fadeTexture = -1;
            }
            this.fadeTexture = GL32.glGenTextures();
            GLMC.glBindTexture(this.fadeTexture);
            GL32.glTexImage2D((int)3553, (int)0, (int)32859, (int)width, (int)height, (int)0, (int)6408, (int)32819, (ByteBuffer)null);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.fadeTexture, (int)0);
        } else {
            GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)MC_RENDER.getColorTextureId(), (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, IClientLevelWrapper level) {
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.pop();
        profiler.push("DH-RenderLevel");
        GLState mcState = new GLState();
        try {
            profiler.push("Fade Generate");
            this.init();
            int width = MC_RENDER.getTargetFrameBufferViewportWidth();
            int height = MC_RENDER.getTargetFrameBufferViewportHeight();
            if (this.width != width || this.height != height) {
                this.width = width;
                this.height = height;
                this.createFramebuffer(width, height);
            }
            FadeShader.INSTANCE.frameBuffer = this.fadeFramebuffer;
            FadeShader.INSTANCE.setProjectionMatrix(mcModelViewMatrix, mcProjectionMatrix, partialTicks);
            FadeShader.INSTANCE.setLevelMaxHeight(level.getMaxHeight());
            FadeShader.INSTANCE.render(partialTicks);
            profiler.popPush("Fade Apply");
            if (MC_RENDER.mcRendersToFrameBuffer()) {
                FadeApplyShader.INSTANCE.fadeTexture = this.fadeTexture;
                FadeApplyShader.INSTANCE.render(partialTicks);
            }
            profiler.pop();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error during fade render, error: [" + e.getMessage() + "].", (Throwable)e);
        }
        finally {
            mcState.restore();
        }
    }

    public void free() {
        FadeShader.INSTANCE.free();
        FadeApplyShader.INSTANCE.free();
    }
}

