/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.Logger;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Map<ServerLevel, WeakReference<ServerLevelWrapper>> LEVEL_WRAPPER_REF_BY_SERVER_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private final ServerLevel level;
    @Deprecated
    private IDhLevel parentDhLevel;

    public static ServerLevelWrapper getWrapper(ServerLevel level) {
        return (ServerLevelWrapper)LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.compute(level, (newLevel, levelRef) -> {
            ServerLevelWrapper oldLevelWrapper;
            if (levelRef != null && (oldLevelWrapper = (ServerLevelWrapper)levelRef.get()) != null) {
                return levelRef;
            }
            return new WeakReference<ServerLevelWrapper>(new ServerLevelWrapper((ServerLevel)newLevel));
        }).get();
    }

    public ServerLevelWrapper(ServerLevel level) {
        this.level = level;
    }

    @Override
    public File getMcSaveFolder() {
        return this.level.getChunkSource().getDataStorage().dataFolder;
    }

    @Override
    public String getWorldFolderName() {
        return ((Path)this.level.getServer().getWorldScreenshotFile().get()).getParent().getFileName().toString();
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public String getDimensionName() {
        return this.level.dimension().location().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.getBiomeManager().biomeZoomSeed;
    }

    @Override
    public String getDhIdentifier() {
        return this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getMaxHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinBuildHeight();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.hasChunk(pos.getX(), pos.getZ())) {
            return null;
        }
        ChunkAccess chunk = this.level.getChunk(pos.getX(), pos.getZ(), ChunkStatus.FULL, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ServerChunkCache source = this.level.getChunkSource();
        return source.hasChunk(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.getBlockState(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.getBiome(McObjectConverter.Convert(pos)), this);
    }

    public ServerLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.remove(this.level);
    }

    @Override
    public void setParentLevel(IDhLevel parentLevel) {
        this.parentDhLevel = parentLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getGenericRenderer();
    }

    @Override
    public File getDhSaveFolder() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getSaveStructure().getSaveFolder(this);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

