/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids;

import com.simibubi.create.AllFluids;
import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(targets={"com.simibubi.create.AllFluids.SolidRenderedPlaceableFluidType"}, source={"create"}, license={"mit"})
public class SolidRenderFluidType
extends AllFluids.TintedFluidType {
    protected static final int NO_ALPHA = 0xFFFFFF;
    private final int tintColor;
    private final int blockTintColor;
    private final Vector3f fogColor;
    private final Supplier<Float> fogDistanceModifier;

    protected SolidRenderFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int tintColor, Vector3f fogColor, Supplier<Float> fogDistanceModifier) {
        super(properties, stillTexture, flowingTexture);
        this.tintColor = tintColor;
        this.blockTintColor = tintColor & 0xFFFFFF;
        this.fogColor = fogColor;
        this.fogDistanceModifier = fogDistanceModifier;
    }

    public static FluidBuilder.FluidTypeFactory create(int tintColor, Vector3f fogColor, Supplier<Float> fogDistanceModifier) {
        return (properties, stillTexture, flowingTexture) -> new SolidRenderFluidType(properties, stillTexture, flowingTexture, tintColor, fogColor, fogDistanceModifier);
    }

    public static FluidBuilder.FluidTypeFactory create(Vector3f fogColor, Supplier<Float> fogDistanceModifier) {
        return (properties, stillTexture, flowingTexture) -> new SolidRenderFluidType(properties, stillTexture, flowingTexture, -1, fogColor, fogDistanceModifier);
    }

    protected int getTintColor(FluidStack stack) {
        return this.tintColor;
    }

    public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
        return this.blockTintColor;
    }

    protected Vector3f getCustomFogColor() {
        return this.fogColor;
    }

    protected float getFogDistanceModifier() {
        return this.fogDistanceModifier.get().floatValue();
    }
}

