/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.coloring;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeInput;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeParams;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipe;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipeBuilder;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;

public class ColoringRecipe
extends CustomProcessingRecipe<ColoringRecipeInput, ColoringRecipeParams> {
    public ColoringRecipe(ColoringRecipeParams params) {
        super(CDPRecipes.COLORING, params);
    }

    public static Builder builder(ResourceLocation id, DyeColor color) {
        return new Builder(id, color);
    }

    public DyeColor getColor() {
        return ((ColoringRecipeParams)this.params).color;
    }

    public boolean matches(ColoringRecipeInput input, Level level) {
        return ((ColoringRecipeParams)this.params).color == input.color() && ((Ingredient)this.ingredients.getFirst()).test(input.item());
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 12;
    }

    public static class Builder
    extends CustomProcessingRecipeBuilder<ColoringRecipeParams, ColoringRecipe> {
        protected Builder(ResourceLocation recipeId, DyeColor color) {
            super(ColoringRecipe::new, recipeId);
            ColoringRecipeParams params = (ColoringRecipeParams)this.params;
            params.color = color;
        }

        @Override
        protected ColoringRecipeParams createParams(ResourceLocation id) {
            return new ColoringRecipeParams(id);
        }
    }
}

