/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.registry;

import com.simibubi.create.AllCreativeModeTabs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeColors;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.config.CDPConfig;

public class CDPCreativeModeTabs {
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"create_dragons_plus");
    public static final Holder<CreativeModeTab> BASE = TABS.register("base", CDPCreativeModeTabs::base);

    public static void register(IEventBus modBus) {
        TABS.register(modBus);
    }

    private static CreativeModeTab base(ResourceLocation id) {
        return CreativeModeTab.builder().title((Component)CDPCommon.REGISTRATE.addLang("itemGroup", id, "Create: Dragons Plus")).withTabsBefore(new ResourceLocation[]{AllCreativeModeTabs.BASE_CREATIVE_TAB.getId()}).icon(() -> CDPItems.RARE_MARBLE_GATE_PACKAGE.asStack()).displayItems(CDPCreativeModeTabs::buildBaseContents).build();
    }

    private static void buildBaseContents(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        if (CDPConfig.features().fluidHatch.get().booleanValue()) {
            output.accept(CDPBlocks.FLUID_HATCH);
        }
        if (CDPConfig.features().blazeUpgradeSmithingTemplate.get().booleanValue()) {
            output.accept(CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE);
        }
        if (CDPConfig.features().dyeFluids.get().booleanValue()) {
            for (DyeColor color : DyeColors.CREATIVE_MODE_TAB) {
                CDPFluids.DYES_BY_COLOR.get(color).getBucket().ifPresent(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            }
        }
        if (CDPConfig.features().dragonBreathFluid.get().booleanValue()) {
            CDPFluids.DRAGON_BREATH.getBucket().ifPresent(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        }
        output.accept(CDPItems.RARE_BLAZE_PACKAGE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        output.accept(CDPItems.RARE_MARBLE_GATE_PACKAGE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
    }
}

