/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.registry;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipe;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeParams;
import plus.dragons.createdragonsplus.common.kinetics.fan.ending.EndingRecipe;
import plus.dragons.createdragonsplus.common.kinetics.fan.freezing.FreezingRecipe;
import plus.dragons.createdragonsplus.common.kinetics.fan.sanding.SandingRecipe;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipeParams;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipeSerializer;
import plus.dragons.createdragonsplus.common.recipe.RecipeTypeInfo;

public class CDPRecipes {
    private static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"create_dragons_plus");
    private static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"create_dragons_plus");
    public static final RecipeTypeInfo<ColoringRecipe> COLORING = CDPRecipes.register("coloring", () -> new CustomProcessingRecipeSerializer<ColoringRecipeParams, ColoringRecipe>(ColoringRecipe::new, ColoringRecipeParams.CODEC, ColoringRecipeParams.STREAM_CODEC));
    public static final RecipeTypeInfo<FreezingRecipe> FREEZING = CDPRecipes.register("freezing", () -> new CustomProcessingRecipeSerializer<CustomProcessingRecipeParams, FreezingRecipe>(FreezingRecipe::new, CustomProcessingRecipeParams.CODEC, CustomProcessingRecipeParams.STREAM_CODEC));
    public static final RecipeTypeInfo<SandingRecipe> SANDING = CDPRecipes.register("sanding", () -> new CustomProcessingRecipeSerializer<CustomProcessingRecipeParams, SandingRecipe>(SandingRecipe::new, CustomProcessingRecipeParams.CODEC, CustomProcessingRecipeParams.STREAM_CODEC));
    public static final RecipeTypeInfo<EndingRecipe> ENDING = CDPRecipes.register("ending", () -> new CustomProcessingRecipeSerializer<CustomProcessingRecipeParams, EndingRecipe>(EndingRecipe::new, CustomProcessingRecipeParams.CODEC, CustomProcessingRecipeParams.STREAM_CODEC));

    public static void register(IEventBus modBus) {
        TYPES.register(modBus);
        SERIALIZERS.register(modBus);
    }

    private static <R extends Recipe<?>> RecipeTypeInfo<R> register(String name, Supplier<? extends RecipeSerializer<R>> serializer) {
        return new RecipeTypeInfo(name, serializer, SERIALIZERS, TYPES);
    }
}

