/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.internal;

import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.recipe.UpdateRecipesEvent;
import plus.dragons.createdragonsplus.config.CDPConfig;

@EventBusSubscriber
public class CDPRuntimeRecipeProvider
extends RecipeProvider {
    public CDPRuntimeRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        if (CDPConfig.features().generateSandPaperPolishingRecipeForPolishedBlocks.get().booleanValue()) {
            CDPRuntimeRecipeProvider.buildPolishedBlockRecipes(output);
        }
    }

    private static void buildPolishedBlockRecipes(RecipeOutput output) {
        BuiltInRegistries.BLOCK.holders().filter(holder -> holder.key().location().getPath().contains("polished_")).forEach(holder -> {
            ResourceLocation polishedId = holder.key().location();
            ResourceLocation baseId = polishedId.withPath(name -> name.replace("polished_", ""));
            if (!BuiltInRegistries.BLOCK.containsKey(baseId)) {
                return;
            }
            Item polishedItem = ((Block)holder.value()).asItem();
            Item baseItem = ((Block)BuiltInRegistries.BLOCK.get(baseId)).asItem();
            if (polishedItem == Items.AIR || baseItem == Items.AIR) {
                return;
            }
            ResourceLocation recipeId = CDPCommon.asResource(baseId.toString().replace(':', '/'));
            new ProcessingRecipeBuilder(SandPaperPolishingRecipe::new, recipeId).require((ItemLike)baseItem).output((ItemLike)polishedItem).build(output);
        });
    }

    private static void buildOxidizedBlockRecipes(RecipeOutput output) {
        DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.forEach((oxidized, polished) -> {
            Item oxidizedItem = oxidized.asItem();
            Item polishedItem = polished.asItem();
            if (oxidizedItem == Items.AIR || polishedItem == Items.AIR) {
                return;
            }
            ResourceLocation oxidizedId = BuiltInRegistries.BLOCK.getKey(oxidized);
            ResourceLocation recipeId = CDPCommon.asResource(oxidizedId.toString().replace(':', '/'));
            new ProcessingRecipeBuilder(SandPaperPolishingRecipe::new, recipeId).require((ItemLike)oxidizedItem).output((ItemLike)polishedItem).build(output);
        });
    }

    private static void buildWaxedBlockRecipes(RecipeOutput output) {
        DataMapHooks.INVERSE_WAXABLES_DATAMAP.forEach((waxed, polished) -> {
            Item waxedItem = waxed.asItem();
            Item polishedItem = polished.asItem();
            if (waxedItem == Items.AIR || polishedItem == Items.AIR) {
                return;
            }
            ResourceLocation waxedId = BuiltInRegistries.BLOCK.getKey(waxed);
            ResourceLocation recipeId = CDPCommon.asResource(waxedId.toString().replace(':', '/'));
            new ProcessingRecipeBuilder(SandPaperPolishingRecipe::new, recipeId).require((ItemLike)waxedItem).output((ItemLike)polishedItem).build(output);
        });
    }

    @SubscribeEvent
    public static void buildRecipesForUpdate(final UpdateRecipesEvent event) {
        RecipeOutput output = new RecipeOutput(){

            public Advancement.Builder advancement() {
                return Advancement.Builder.advancement();
            }

            public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
                event.addRecipe(new RecipeHolder(id, recipe));
            }
        };
        if (CDPConfig.features().generateSandPaperPolishingRecipeForOxidizedBlocks.get().booleanValue()) {
            CDPRuntimeRecipeProvider.buildOxidizedBlockRecipes(output);
        }
        if (CDPConfig.features().generateSandPaperPolishingRecipeForWaxedBlocks.get().booleanValue()) {
            CDPRuntimeRecipeProvider.buildWaxedBlockRecipes(output);
        }
    }
}

