/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.recipe.BaseRecipeBuilder;
import plus.dragons.createdragonsplus.data.recipe.integration.IntegrationResultRecipe;

public abstract class BaseSingleItemRecipeBuilder<R extends Recipe<?>, B extends BaseSingleItemRecipeBuilder<R, B>>
extends BaseRecipeBuilder<R, B> {
    protected Ingredient ingredient = Ingredient.EMPTY;
    protected ItemStack result = ItemStack.EMPTY;

    protected BaseSingleItemRecipeBuilder(@Nullable String directory) {
        super(directory);
    }

    public B require(TagKey<Item> tag) {
        return this.require(Ingredient.of(tag));
    }

    public B require(ItemLike item) {
        return this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public B require(Ingredient ingredient) {
        this.ingredient = ingredient;
        return (B)((BaseSingleItemRecipeBuilder)this.builder());
    }

    public B output(ItemLike item) {
        this.result = new ItemStack(item);
        return (B)((BaseSingleItemRecipeBuilder)this.builder());
    }

    public B output(ItemLike item, int count) {
        this.result = new ItemStack(item, count);
        return (B)((BaseSingleItemRecipeBuilder)this.builder());
    }

    public B output(ItemStack stack) {
        this.result = stack;
        return (B)((BaseSingleItemRecipeBuilder)this.builder());
    }

    public IntegrationResultRecipe.Builder output(ResourceLocation result) {
        return new IntegrationResultRecipe.Builder(this, this.result, result);
    }
}

