/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientBoundOpenScreenPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundOpenScreenPacket> TYPE = Message.makeType(Moonlight.res("s2c_open_screen"), ClientBoundOpenScreenPacket::new);
    public final BlockPos pos;
    private final Direction dir;

    public ClientBoundOpenScreenPacket(RegistryFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dir = Direction.from3DDataValue((int)buffer.readVarInt());
    }

    public ClientBoundOpenScreenPacket(BlockPos pos, Direction hitFace) {
        this.pos = pos;
        this.dir = hitFace;
    }

    @Override
    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeVarInt(this.dir.get3DDataValue());
    }

    @Override
    public void handle(Message.Context context) {
        BlockPos pos;
        Player player = context.getPlayer();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(pos = this.pos);
        if (blockEntity instanceof IScreenProvider) {
            IScreenProvider tile = (IScreenProvider)blockEntity;
            tile.openScreen(level, pos, player, this.dir);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

