/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.neoforge;

import java.lang.ref.WeakReference;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevelManager;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge.ModIngredientTypes;
import net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge.ResourceConditionsBridge;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fake_player.FPClientAccess;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.integration.neoforge.ModConfigSelectScreen;
import net.mehvahdjukaar.moonlight.core.misc.neoforge.ModLootConditions;
import net.mehvahdjukaar.moonlight.core.misc.neoforge.ModLootModifiers;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForgeClient;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

@Mod(value="moonlight")
public class MoonlightForge {
    public static final String MOD_ID = "moonlight";
    @Nullable
    private static WeakReference<ICondition.IContext> context = null;
    private static WeakReference<IEventBus> currentBus = null;

    public MoonlightForge(IEventBus bus) {
        RegHelper.startRegisteringFor(bus);
        Moonlight.commonInit();
        NeoForge.EVENT_BUS.register(MoonlightForge.class);
        bus.addListener(MoonlightForge::registerCapabilities);
        ModLootModifiers.register();
        ModLootConditions.register();
        ModIngredientTypes.register();
        ResourceConditionsBridge.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightForgeClient.init(bus);
            if (PlatHelper.isModLoaded("configured")) {
                ModConfigSelectScreen.registerConfigScreen(MOD_ID, ModConfigSelectScreen::new);
            }
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (Map.Entry e : BuiltInRegistries.BLOCK_ENTITY_TYPE.entrySet()) {
            String modId = ((ResourceKey)e.getKey()).location().getNamespace();
            if (!Moonlight.isDependant(modId)) continue;
            try {
                BlockEntityType beType = (BlockEntityType)e.getValue();
                BlockEntity instance = beType.create(BlockPos.ZERO, ((Block)beType.getValidBlocks().stream().findFirst().get()).defaultBlockState());
                if (!(instance instanceof ItemDisplayTile)) continue;
                MoonlightForge.registerDefaultItemCap(event, beType);
            }
            catch (Exception exception) {}
        }
    }

    private static void registerDefaultItemCap(RegisterCapabilitiesEvent event, BlockEntityType<?> beType) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, beType, (sidedContainer, side) -> side == null ? new InvWrapper((Container)sidedContainer) : new SidedInvWrapper((WorldlyContainer)sidedContainer, side));
    }

    @Nullable
    public static ICondition.IContext getConditionContext() {
        if (context == null) {
            return null;
        }
        return (ICondition.IContext)context.get();
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        context = new WeakReference<ICondition.IContext>(event.getConditionContext());
    }

    @SubscribeEvent
    public static void beforeServerStart(ServerAboutToStartEvent event) {
        Moonlight.beforeServerStart((RegistryAccess)event.getServer().registryAccess());
    }

    @SubscribeEvent
    public static void onServerShuttingDown(ServerStoppingEvent event) {
        FakeLevelManager.invalidateAll();
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            SoftFluidInternal.onDataSyncToPlayer(event.getPlayer(), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                NetworkHelper.sendToClientPlayer(player2, new ClientBoundSendLoginPacket());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDimensionUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        try {
            if (level.isClientSide()) {
                FPClientAccess.unloadLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Moonlight.onPlayerCloned(event.getOriginal(), event.getEntity(), event.isWasDeath());
    }

    public static IEventBus getCurrentBus() {
        if (currentBus == null || currentBus.get() == null) {
            throw new IllegalStateException("Bus is null. You must call RegHelper.startRegistering(IEventBus) before registering events");
        }
        return (IEventBus)currentBus.get();
    }

    public static void startRegistering(IEventBus bus) {
        currentBus = new WeakReference<IEventBus>(bus);
    }
}

