/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.CEIEnchantmentHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.common.registry.CEIEnchantments;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEIIntIntPair;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class EnchantedBookPrintingBehaviour
implements PrintingBehaviour {
    private final Level level;
    private final SmartFluidTankBehaviour tank;
    private final ItemStack original;
    private final ItemEnchantments enchantments;
    private final int cost;

    private EnchantedBookPrintingBehaviour(Level level, SmartFluidTankBehaviour tank, ItemStack original, ItemEnchantments enchantments) {
        this.level = level;
        this.tank = tank;
        this.original = original;
        this.enchantments = enchantments;
        AtomicInteger result = new AtomicInteger(0);
        enchantments.entrySet().forEach(entry -> {
            Optional<CEIIntIntPair> optional = Optional.empty();
            List customCost = (List)((Holder)entry.getKey()).getData(CEIDataMaps.PRINTING_ENCHANTED_BOOK_COST);
            if (customCost != null) {
                optional = customCost.stream().filter(pair -> pair.level() == entry.getIntValue()).findFirst();
            }
            result.addAndGet(optional.map(CEIIntIntPair::value).orElseGet(() -> CEIEnchantmentHelper.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue())));
        });
        this.cost = result.get();
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        if (!stack.is(Items.ENCHANTED_BOOK)) {
            return Optional.empty();
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.enchanted_book.invalid")));
        }
        if (enchantments.keySet().stream().anyMatch(enchantment -> enchantment.is(CEIEnchantments.MOD_TAGS.printingDeny))) {
            if (((Boolean)CEIConfig.fluids().printingEnchantedBookDenylistStopCopying.get()).booleanValue()) {
                return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.enchanted_book.denied")));
            }
            List<Holder> rest = enchantments.keySet().stream().filter(enchantment -> !enchantment.is(CEIEnchantments.MOD_TAGS.printingDeny)).toList();
            if (rest.isEmpty()) {
                return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.enchanted_book.all_denied")));
            }
            ItemEnchantments.Mutable result = new ItemEnchantments.Mutable(enchantments);
            result.removeIf(rest::contains);
            return Optional.of(DataResult.success((Object)new EnchantedBookPrintingBehaviour(level, tank, stack, result.toImmutable())));
        }
        return Optional.of(DataResult.success((Object)new EnchantedBookPrintingBehaviour(level, tank, stack, enchantments)));
    }

    private OptionalInt getCost(FluidStack fluid) {
        int cost = this.cost;
        if ((cost = ExperienceHelper.getFluidFromExperience(fluid, cost)) == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(cost);
    }

    @Override
    public boolean isValid() {
        if (this.cost <= 0) {
            return false;
        }
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        if (fluid.isEmpty()) {
            return true;
        }
        OptionalInt cost = this.getCost(fluid);
        return cost.isPresent() && cost.getAsInt() <= (Integer)CEIConfig.fluids().printerFluidCapacity.get();
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        if (stack.is(Items.BOOK)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        return this.getCost(fluidStack).orElse(0);
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        ItemStack result = stack.transmuteCopy((ItemLike)Items.ENCHANTED_BOOK, 1);
        result.set(DataComponents.STORED_ENCHANTMENTS, (Object)this.enchantments);
        return result;
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.playSound(null, pos.below(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CEILang.translate("gui.goggles.printing", new Object[0]).forGoggles(tooltip);
        CEILang.item(this.original).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        this.getCost(this.tank.getPrimaryHandler().getFluid()).ifPresent(cost -> CEILang.translate("gui.goggles.printing.cost", CEILang.number(cost).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(cost <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).style(ChatFormatting.GRAY).forGoggles(tooltip));
        RegistryAccess registries = this.level.registryAccess();
        HolderSet order = registries.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.TOOLTIP_ORDER).map(holders -> holders).orElse((HolderSet)HolderSet.direct((Holder[])new Holder[0]));
        for (Holder ordered : order) {
            int level = this.enchantments.getLevel(ordered);
            if (level <= 0) continue;
            CEILang.builder().add(Enchantment.getFullname((Holder)ordered, (int)level)).forGoggles(tooltip, 1);
        }
        for (Object2IntMap.Entry entry : this.enchantments.entrySet()) {
            Holder unordered = (Holder)entry.getKey();
            int level = entry.getIntValue();
            if (level <= 0 || order.contains(unordered)) continue;
            CEILang.builder().add(Enchantment.getFullname((Holder)unordered, (int)level)).forGoggles(tooltip, 1);
        }
        return true;
    }
}

