/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipe;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipeBuilder;
import plus.dragons.createdragonsplus.common.recipe.CustomProcessingRecipeParams;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.integration.jei.category.assembly.AssemblyGrindingCategory;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class GrindingRecipe
extends CustomProcessingRecipe<SingleRecipeInput, CustomProcessingRecipeParams>
implements IAssemblyRecipe {
    public GrindingRecipe(CustomProcessingRecipeParams params) {
        super(CEIRecipes.GRINDING, params);
        if (this.fluidIngredients.size() + this.fluidResults.size() > 1) {
            throw new IllegalArgumentException("Grinding recipe can only have either 1 fluid input or 1 fluid result");
        }
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static Optional<RecipeHolder<GrindingRecipe>> fromPolishing(RecipeHolder<SandPaperPolishingRecipe> recipe) {
        if (AllRecipeTypes.CAN_BE_AUTOMATED.test(recipe)) {
            ResourceLocation id = recipe.id().withSuffix("_using_grindstone");
            SandPaperPolishingRecipe polishing = (SandPaperPolishingRecipe)recipe.value();
            GrindingRecipe grinding = (GrindingRecipe)GrindingRecipe.builder(id).require((Ingredient)polishing.getIngredients().getFirst()).output((ProcessingOutput)polishing.getRollableResults().getFirst()).build();
            return Optional.of(new RecipeHolder(id, (Recipe)grinding));
        }
        return Optional.empty();
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidOutputCount() {
        return 1;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return ((Ingredient)this.ingredients.getFirst()).test(input.item());
    }

    public Component getDescriptionForAssembly() {
        if (this.fluidIngredients.isEmpty()) {
            return CEILang.translate("recipe.assembly.grinding", new Object[0]).component();
        }
        List matchingFluidStacks = ((FluidIngredient)this.fluidIngredients.getFirst()).getMatchingFluidStacks();
        if (matchingFluidStacks.isEmpty()) {
            return Component.literal((String)"Invalid");
        }
        return CEILang.translate("recipe.assembly.grinding.needs_fluid", ((FluidStack)matchingFluidStacks.getFirst()).getHoverName()).component();
    }

    public void addRequiredMachines(Set<ItemLike> required) {
        required.add((ItemLike)CEIBlocks.MECHANICAL_GRINDSTONE);
        required.add((ItemLike)AllBlocks.ITEM_DRAIN);
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyGrindingCategory::new;
    }

    public static class Builder
    extends CustomProcessingRecipeBuilder<CustomProcessingRecipeParams, GrindingRecipe> {
        protected Builder(ResourceLocation id) {
            super(GrindingRecipe::new, id);
        }

        protected CustomProcessingRecipeParams createParams(ResourceLocation id) {
            return new CustomProcessingRecipeParams(id);
        }
    }
}

