/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.enchanter.behaviour;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.CEIEnchantmentHelper;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.EnchantingTemplateItem;
import plus.dragons.createenchantmentindustry.common.registry.CEIEnchantments;

public class EnchantingBehaviour {
    protected int enchantingLevel;
    protected TagKey<Enchantment> enchantmentTag;
    protected List<EnchantmentInstance> enchantments;

    public EnchantingBehaviour() {
        this.enchantmentTag = CEIEnchantments.MOD_TAGS.enchanting;
        this.enchantments = new ArrayList<EnchantmentInstance>(0);
    }

    protected List<EnchantmentInstance> getAvailableEnchantments(Level level, ItemStack stack, boolean special) {
        int adjustedLevel = CEIEnchantmentHelper.getAdjustedLevel(stack, this.enchantingLevel);
        if (adjustedLevel == 0) {
            return new ArrayList<EnchantmentInstance>(0);
        }
        Stream<Holder<Enchantment>> possible = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(this.enchantmentTag).stream().flatMap(HolderSet::stream).filter(arg_0 -> ((ItemStack)stack).isPrimaryItemFor(arg_0));
        return CEIEnchantmentHelper.getAvailableEnchantmentResults(adjustedLevel, possible, special);
    }

    protected List<EnchantmentInstance> getAvailableCurses(Level level, ItemStack stack) {
        int adjustedLevel = CEIEnchantmentHelper.getAdjustedLevel(stack, this.enchantingLevel);
        if (adjustedLevel == 0) {
            return new ArrayList<EnchantmentInstance>(0);
        }
        Stream<Holder<Enchantment>> possible = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.CURSE).stream().flatMap(HolderSet::stream).filter(arg_0 -> ((ItemStack)stack).isPrimaryItemFor(arg_0));
        return CEIEnchantmentHelper.getAvailableEnchantmentResults(adjustedLevel, possible, true);
    }

    public boolean canProcess(Level level, ItemStack stack, boolean special) {
        if (stack.getItem() instanceof EnchantingTemplateItem) {
            return false;
        }
        return stack.isEnchantable() && !this.getAvailableEnchantments(level, stack, special).isEmpty();
    }

    public void update(Level level, ItemStack stack, int enchantingLevel, boolean special, boolean cursed) {
        this.enchantingLevel = enchantingLevel;
        this.enchantmentTag = special ? CEIEnchantments.MOD_TAGS.superEnchanting : CEIEnchantments.MOD_TAGS.enchanting;
        this.enchantments = this.getAvailableEnchantments(level, stack, special);
        if (!this.enchantments.isEmpty() && cursed) {
            this.enchantments.addAll(this.getAvailableCurses(level, stack));
        }
    }

    public ItemStack getResult(Level level, ItemStack stack, RandomSource random, boolean special) {
        int adjustedLevel = CEIEnchantmentHelper.getAdjustedLevel(stack, this.enchantingLevel);
        List<EnchantmentInstance> enchantments = CEIEnchantmentHelper.selectEnchantments(random, adjustedLevel, this.enchantments, special);
        if (stack.is(Items.BOOK) && enchantments.size() > 1) {
            enchantments.remove(random.nextInt(enchantments.size()));
        }
        return stack.getItem().applyEnchantments(stack, enchantments);
    }

    public int getExperienceCost() {
        if (this.enchantments.isEmpty()) {
            return 0;
        }
        int levelCost = Math.ceilDiv(this.enchantingLevel, 10);
        int experienceCost = 0;
        for (int i = 0; i < levelCost; ++i) {
            experienceCost += ExperienceHelper.getExperienceForNextLevel(this.enchantingLevel - i);
        }
        return experienceCost;
    }
}

