/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.forger;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlockEntity;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlockRenderer;
import plus.dragons.createenchantmentindustry.common.processing.forger.BlazeForgerBlockEntity;

public class BlazeForgerRenderer
extends BlazeBlockRenderer<BlazeForgerBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BlazeForgerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    protected void renderSafe(BlazeForgerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack item = blockEntity.inventory.getStackInSlot(slot);
            if (item.isEmpty()) continue;
            this.renderItem(blockEntity, item, slot, blockEntity.processingTime, partialTicks, poseStack, bufferSource, light, overlay);
        }
        if (VisualizationManager.supportsVisualization((LevelAccessor)blockEntity.getLevel())) {
            return;
        }
        super.renderSafe((BlazeBlockEntity)blockEntity, partialTicks, poseStack, bufferSource, light, overlay);
    }

    protected void renderItem(BlazeForgerBlockEntity blockEntity, ItemStack item, int slot, int processingTime, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        Level level = blockEntity.getLevel();
        assert (level != null);
        BlockPos blockPos = blockEntity.getBlockPos();
        float renderTicks = AnimationTickHolder.getTicks((LevelAccessor)level);
        float animation = processingTime == -1 ? Mth.sin((float)((float)slot * (float)Math.PI / -2.0f)) : Mth.sin((float)(((float)processingTime + partialTicks) / 20.0f + (float)slot * (float)Math.PI));
        float height = 1.25f + (1.0f + animation) * 0.25f;
        float xRot = (renderTicks * 5.0f + (float)blockPos.getX() + (float)(slot * 180)) % 360.0f;
        float zRot = (renderTicks * 5.0f + (float)blockPos.getZ() + (float)(slot * 180)) % 360.0f;
        poseStack.pushPose();
        poseStack.translate(0.5f, height, 0.5f);
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(zRot));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, light, overlay, poseStack, bufferSource, level, ((Object)((Object)blockEntity)).hashCode());
        poseStack.popPose();
    }
}

