/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.printing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.recipe.IRecipeManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.CommonHooks;
import plus.dragons.createdragonsplus.util.Pairs;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.CEIEnchantmentHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.common.registry.CEIEnchantments;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.util.CEIIntIntPair;

public class EnchantedBookPrintingRecipeJEI
implements PrintingRecipeJEI {
    public static final PrintingRecipeJEI.Type TYPE = PrintingRecipeJEI.register(CEICommon.asResource("enchanted_book"), EnchantedBookPrintingRecipeJEI::createCodec);
    private final ResourceLocation id;
    private final EnchantmentInstance enchantment;
    private final ItemStack enchantmentBook;
    private final int cost;

    public EnchantedBookPrintingRecipeJEI(EnchantmentInstance enchantment) {
        this.id = PrintingRecipeJEI.super.getRegistryName().withSuffix("/" + enchantment.enchantment.getRegisteredName().replace(':', '/') + enchantment.level);
        this.enchantment = enchantment;
        this.enchantmentBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)enchantment);
        Optional<CEIIntIntPair> optional = Optional.empty();
        List customCost = (List)enchantment.enchantment.getData(CEIDataMaps.PRINTING_ENCHANTED_BOOK_COST);
        if (customCost != null) {
            optional = customCost.stream().filter(pair -> pair.level() == enchantment.level).findFirst();
        }
        this.cost = optional.map(CEIIntIntPair::value).orElseGet(() -> CEIEnchantmentHelper.getEnchantmentCost((Holder<Enchantment>)enchantment.enchantment, enchantment.level));
    }

    public static MapCodec<EnchantedBookPrintingRecipeJEI> createCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(it -> it.enchantment), (App)Codec.INT.fieldOf("level").forGetter(it -> it.level)).apply((Applicative)instance, EnchantmentInstance::new)).xmap(EnchantedBookPrintingRecipeJEI::new, recipe -> recipe.enchantment);
    }

    public static List<PrintingRecipeJEI> listAll() {
        return Objects.requireNonNull(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).listElements().filter(enchantment -> !enchantment.is(CEIEnchantments.MOD_TAGS.printingDeny)).flatMap(enchantment -> IntStream.rangeClosed(((Enchantment)enchantment.value()).getMinLevel(), CEIEnchantmentHelper.maxLevel((Holder<Enchantment>)enchantment)).mapToObj(level -> new EnchantedBookPrintingRecipeJEI(new EnchantmentInstance((Holder)enchantment, level)))).collect(Collectors.toList());
    }

    @Override
    public void setBase(IRecipeSlotBuilder slot) {
        slot.addItemLike((ItemLike)Items.BOOK);
    }

    @Override
    public void setTemplate(IRecipeSlotBuilder slot) {
        slot.addItemStack(this.enchantmentBook);
    }

    @Override
    public void setFluid(IRecipeSlotBuilder slot) {
        slot.addFluidStack((Fluid)CEIFluids.EXPERIENCE.get(), (long)this.cost);
        CEIDataMaps.getSourceFluidEntries(CEIDataMaps.FLUID_UNIT_EXPERIENCE).forEach(Pairs.accept((fluid, unit) -> slot.addFluidStack(fluid, (long)unit.intValue() * (long)this.cost)));
    }

    @Override
    public void setOutput(IRecipeSlotBuilder slot) {
        slot.addItemStack(this.enchantmentBook);
    }

    @Override
    public PrintingRecipeJEI.Type getType() {
        return TYPE;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.id;
    }
}

