/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.common;

import com.simibubi.create.foundation.item.ItemDescription;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.dragons.createcentralkitchen.common.registry.CCKArmInteractionPointTypes;
import plus.dragons.createcentralkitchen.config.CCKConfig;
import plus.dragons.createcentralkitchen.data.CCKBlockTags;
import plus.dragons.createcentralkitchen.data.CCKItemTags;
import plus.dragons.createcentralkitchen.data.CCKLang;
import plus.dragons.createdragonsplus.common.CDPRegistrate;
import plus.dragons.createdragonsplus.data.runtime.RuntimePackResources;

@Mod(value="create_central_kitchen")
public class CCKCommon {
    public static final String ID = "create_central_kitchen";
    public static final String NAME = "Create: Central Kitchen";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Central Kitchen");
    public static final CDPRegistrate REGISTRATE = new CDPRegistrate("create_central_kitchen").setTooltipModifier(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE)).registerForeignLocalization();
    private final ModContainer modContainer;

    public CCKCommon(IEventBus modBus, ModContainer modContainer) {
        this.modContainer = modContainer;
        REGISTRATE.registerEventListeners(modBus);
        CCKArmInteractionPointTypes.register(modBus);
        modBus.register((Object)this);
        modBus.register((Object)new CCKConfig(modContainer));
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        PackType type = event.getPackType();
        CompletableFuture<RegistryAccess.Frozen> registries = CompletableFuture.completedFuture(RegistryLayer.createRegistryAccess().compositeAccess());
        if (type == PackType.SERVER_DATA) {
            RuntimePackResources pack = new RuntimePackResources("runtime", this.modContainer, type, Pack.Position.TOP, CCKLang.RUNTIME_PACK_TITLE, CCKLang.RUNTIME_PACK_DESCRIPTION);
            PackOutput output = pack.getPackOutput();
            ExistingFileHelper existingFileHelper = new ExistingFileHelper(Set.of(), Set.of(), false, null, null);
            CCKBlockTags blockTags = new CCKBlockTags(output, registries, existingFileHelper);
            CCKItemTags itemTags = new CCKItemTags(output, registries, blockTags.contentsGetter(), existingFileHelper);
            pack.addDataProvider((DataProvider)blockTags);
            pack.addDataProvider((DataProvider)itemTags);
            event.addRepositorySource((RepositorySource)pack);
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

