/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.Provider;
import dev.tr7zw.entityculling.util.ComponentProvider;
import dev.tr7zw.entityculling.util.NMSHelper;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;

public abstract class EntityCullingModBase
extends EntityCullingVersionlessBase {
    public static EntityCullingModBase instance;
    public Set<BlockEntityType<?>> blockEntityWhitelist = new HashSet();
    public Set<EntityType<?>> entityWhistelist = new HashSet();
    public Set<EntityType<?>> tickCullWhistelist = new HashSet();
    public CullTask cullTask;
    protected KeyMapping keybind = new KeyMapping("key.entityculling.toggle", -1, "text.entityculling.title");
    protected KeyMapping keybindBoxes = new KeyMapping("key.entityculling.toggleBoxes", -1, "text.entityculling.title");
    private Set<Function<BlockEntity, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<BlockEntity, Boolean>>();
    private Set<Function<Entity, Boolean>> dynamicEntityWhitelist = new HashSet<Function<Entity, Boolean>>();

    @Override
    public void onInitialize() {
        instance = this;
        super.onInitialize();
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhistelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> LOGGER.error("The CullingThread has crashed! Please report the following stacktrace!", ex));
        this.initModloader();
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        if (!this.lateInit) {
            Optional entity;
            this.lateInit = true;
            this.cullThread.start();
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(NMSHelper.getResourceLocation(blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((BlockEntityType<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = BuiltInRegistries.ENTITY_TYPE.getOptional(NMSHelper.getResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = BuiltInRegistries.ENTITY_TYPE.getOptional(NMSHelper.getResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
        }
        if (this.keybind.isDown()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            boolean bl = enabled = !enabled;
            if (enabled) {
                NMSHelper.sendChatMessage((Component)ComponentProvider.literal("Culling on").withStyle(ChatFormatting.GREEN));
            } else {
                NMSHelper.sendChatMessage((Component)ComponentProvider.literal("Culling off").withStyle(ChatFormatting.RED));
            }
        } else {
            this.pressed = false;
        }
        if (this.keybindBoxes.isDown()) {
            if (this.pressedBox) {
                return;
            }
            this.pressedBox = true;
            boolean bl = this.debugHitboxes = !this.debugHitboxes;
            if (this.debugHitboxes) {
                NMSHelper.sendChatMessage((Component)ComponentProvider.literal("Debug Cullboxes on").withStyle(ChatFormatting.GREEN));
            } else {
                NMSHelper.sendChatMessage((Component)ComponentProvider.literal("Debug Cullboxes off").withStyle(ChatFormatting.RED));
            }
        } else {
            this.pressedBox = false;
        }
        this.cullTask.requestCull = true;
    }

    public abstract AABB setupAABB(BlockEntity var1, BlockPos var2);

    public boolean isDynamicWhitelisted(BlockEntity entity) {
        for (Function<BlockEntity, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(Entity entity) {
        for (Function<Entity, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<BlockEntity, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<Entity, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }
}

