/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.draw_helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.flashyreese.mods.sodiumextra.client.render.vertex.formats.TextureColorVertex;
import me.flashyreese.mods.sodiumextra.client.render.vertex.formats.TextureVertex;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1500)
public abstract class MixinGuiGraphics {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;

    @Shadow
    @Deprecated
    protected abstract void flushIfUnmanaged();

    @Inject(method={"fillGradient(Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillGradient(VertexConsumer vertexConsumer, int startX, int startY, int endX, int endY, int z, int colorStart, int colorEnd, CallbackInfo ci) {
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)vertexConsumer);
        Matrix4f matrix4f = this.pose.last().pose();
        colorStart = ColorARGB.toABGR((int)colorStart);
        colorEnd = ColorARGB.toABGR((int)colorEnd);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            ColorVertex.put((long)ptr, (Matrix4f)matrix4f, (float)startX, (float)startY, (float)z, (int)colorStart);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)startX, (float)endY, (float)z, (int)colorEnd);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)endX, (float)endY, (float)z, (int)colorEnd);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)endX, (float)startY, (float)z, (int)colorStart);
            ptr += 16L;
            writer.push(stack, buffer, 4, ColorVertex.FORMAT);
        }
        ci.cancel();
    }

    @Inject(method={"fill(Lnet/minecraft/client/renderer/RenderType;IIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void fill(RenderType type, int x1, int y1, int x2, int y2, int z, int color, CallbackInfo ci) {
        int i;
        Matrix4f matrix4f = this.pose.last().pose();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        VertexConsumer vertexConsumer = this.bufferSource.getBuffer(type);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)vertexConsumer);
        color = ColorARGB.toABGR((int)color);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            ColorVertex.put((long)ptr, (Matrix4f)matrix4f, (float)x1, (float)y1, (float)z, (int)color);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)x1, (float)y2, (float)z, (int)color);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)x2, (float)y2, (float)z, (int)color);
            ColorVertex.put((long)(ptr += 16L), (Matrix4f)matrix4f, (float)x2, (float)y1, (float)z, (int)color);
            ptr += 16L;
            writer.push(stack, buffer, 4, ColorVertex.FORMAT);
        }
        this.flushIfUnmanaged();
        ci.cancel();
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawTexturedQuad(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, CallbackInfo ci) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = this.pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(80);
            TextureVertex.write(ptr, matrix4f, x1, y1, z, u1, v1);
            TextureVertex.write(ptr += 20L, matrix4f, x1, y2, z, u1, v2);
            TextureVertex.write(ptr += 20L, matrix4f, x2, y2, z, u2, v2);
            TextureVertex.write(ptr += 20L, matrix4f, x2, y1, z, u2, v1);
            ptr += 20L;
            writer.push(stack, buffer, 4, TextureVertex.FORMAT);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        ci.cancel();
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawTexturedQuad(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha, CallbackInfo ci) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = this.pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        int color = ColorABGR.pack((float)red, (float)green, (float)blue, (float)alpha);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(96);
            TextureColorVertex.write(ptr, matrix4f, x1, y1, z, color, u1, v1);
            TextureColorVertex.write(ptr += 24L, matrix4f, x1, y2, z, color, u1, v2);
            TextureColorVertex.write(ptr += 24L, matrix4f, x2, y2, z, color, u2, v2);
            TextureColorVertex.write(ptr += 24L, matrix4f, x2, y1, z, color, u2, v1);
            ptr += 24L;
            writer.push(stack, buffer, 4, TextureColorVertex.FORMAT);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        ci.cancel();
    }
}

