/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createliquidfuel.mixin;

import com.forsteri.createliquidfuel.core.BurnerStomachHandler;
import com.forsteri.createliquidfuel.core.IHasStomach;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlazeBurnerBlockEntity.class}, remap=false)
public abstract class MixinBlazeBurnerTileEntity
extends SmartBlockEntity
implements IHasStomach {
    @Unique
    public SmartFluidTank createliquidfuel$stomach;

    public MixinBlazeBurnerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Unique
    public SmartFluidTank getCapability() {
        return this.createliquidfuel$stomach;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createliquidfuel$stomach = new SmartFluidTank(this, 1000, contents -> {}){

            public boolean isFluidValid(@NotNull FluidStack stack) {
                return BurnerStomachHandler.LIQUID_BURNER_FUEL_MAP.containsKey(stack.getFluid());
            }
        };
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo info) {
        BurnerStomachHandler.tick(this);
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (this.createliquidfuel$stomach != null) {
            this.createliquidfuel$stomach.readFromNBT(registries, compound.getCompound("Stomach"));
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (this.createliquidfuel$stomach != null) {
            compound.put("Stomach", (Tag)this.createliquidfuel$stomach.writeToNBT(registries, new CompoundTag()));
        }
    }

    @Inject(method={"tryUpdateFuel"}, at={@At(value="HEAD")}, cancellable=true)
    public void tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        BurnerStomachHandler.tryUpdateFuel(this, itemStack, forceOverflow, simulate, cir);
    }
}

