/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.overpoweredmending.common;

import fr.rakambda.overpoweredmending.common.inventory.IInventoryProvider;
import fr.rakambda.overpoweredmending.common.inventory.PlayerInventoryProvider;
import fr.rakambda.overpoweredmending.common.wrapper.IItemStack;
import fr.rakambda.overpoweredmending.common.wrapper.IPlayer;
import fr.rakambda.overpoweredmending.common.wrapper.IXpOrb;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.jspecify.annotations.NonNull;

public abstract class OverpoweredMendingCommon {
    private static final int DURABILITY_PER_XP = 2;
    private final Collection<IInventoryProvider> inventoryProviders = new LinkedList<IInventoryProvider>();

    public OverpoweredMendingCommon() {
        this.inventoryProviders.add(new PlayerInventoryProvider());
    }

    public void addInventoryProvider(@NonNull IInventoryProvider provider) {
        this.inventoryProviders.add(provider);
    }

    public boolean onXpPickedUp(@NonNull IPlayer player, @NonNull IXpOrb xpOrb) {
        IItemStack item = this.getDamagedEnchantedItem(player);
        player.setExperiencePickUpDelay(2);
        player.sendPickup(xpOrb, 1);
        int xpAmount = xpOrb.getExperienceAmount();
        while (!item.isEmpty() && xpAmount > 0) {
            int realRepair = Math.min(xpAmount * 2, item.getDamageValue());
            xpOrb.setExperienceAmount(xpAmount -= realRepair / 2);
            item.setDamageValue(item.getDamageValue() - realRepair);
            item = this.getDamagedEnchantedItem(player);
        }
        if (xpAmount > 0) {
            player.addExperience(xpAmount);
        }
        xpOrb.discard();
        return true;
    }

    private @NonNull IItemStack getDamagedEnchantedItem(@NonNull IPlayer player) {
        return this.inventoryProviders.stream().flatMap(provider -> provider.getInventoryContent(player)).filter(is -> !is.isEmpty()).filter(IItemStack::isDamageableItem).filter(IItemStack::isDamaged).filter(IItemStack::hasMendingEnchant).max(Comparator.comparingInt(IItemStack::getDamageValue)).orElse(this.getEmptyItemStack());
    }

    protected abstract @NonNull IItemStack getEmptyItemStack();
}

