/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.overpoweredmending.forge.wrapper;

import fr.rakambda.overpoweredmending.common.wrapper.IItemStack;
import fr.rakambda.overpoweredmending.common.wrapper.IPlayer;
import fr.rakambda.overpoweredmending.common.wrapper.IXpOrb;
import fr.rakambda.overpoweredmending.forge.wrapper.ItemStackWrapper;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jspecify.annotations.NonNull;

public class PlayerWrapper
implements IPlayer {
    private final @NonNull Player raw;

    @Override
    public @NonNull Stream<IItemStack> streamInventory() {
        Inventory playerInventory = this.raw.getInventory();
        return IntStream.range(0, playerInventory.getContainerSize()).mapToObj(arg_0 -> ((Inventory)playerInventory).getItem(arg_0)).map(ItemStackWrapper::new);
    }

    @Override
    public void addExperience(int amount) {
        this.raw.giveExperiencePoints(amount);
    }

    @Override
    public void sendPickup(@NonNull IXpOrb xp, int count) {
        this.raw.take((Entity)xp.getRaw(), count);
    }

    @Override
    public void setExperiencePickUpDelay(int delay) {
        this.raw.takeXpDelay = delay;
    }

    @Generated
    public PlayerWrapper(@NonNull Player raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "PlayerWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull Player getRaw() {
        return this.raw;
    }
}

