/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer;

import com.glektarssza.gtnh_customizer.CommonProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.event.entity.player.BonemealEvent;
import org.apache.logging.log4j.Logger;
import serverutils.events.ServerUtilitiesPreInitRegistryEvent;

@Mod(modid="gtnh_customizer", name="Gregtech: New Horizons Customizer", version="v0.12.0", dependencies="", acceptableRemoteVersions="*", guiFactory="com.glektarssza.gtnh_customizer.config.GuiFactory")
public class GTNHCustomizer {
    @SidedProxy(modId="gtnh_customizer", serverSide="com.glektarssza.gtnh_customizer.CommonProxy", clientSide="com.glektarssza.gtnh_customizer.ClientProxy")
    private static CommonProxy proxy;
    public static final int WARNING_EMIT_LIMIT = 20;
    public static final Map<String, Integer> WARNING_LIMIT_TRACKER;
    @Mod.Instance
    public static GTNHCustomizer instance;

    public static Logger getLogger() {
        return proxy.getLogger();
    }

    public File getConfigDir() {
        return proxy.getConfigDir();
    }

    public static boolean shouldEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        return WARNING_LIMIT_TRACKER.get(category) > 0;
    }

    public static void trackEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        int limit = WARNING_LIMIT_TRACKER.compute(category, (_k, v) -> v - 1);
        if (limit <= 0) {
            GTNHCustomizer.getLogger().warn(String.format("Too many identical warnings logged for category \"%s\"! Silencing further warnings on this issue!", category));
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    @SubscribeEvent
    public void onServerUtilitiesPreInitRegistry(ServerUtilitiesPreInitRegistryEvent event) {
        proxy.serverUtilitiesPreInitRegistry(event);
    }

    @SubscribeEvent
    public void onBoneMeal(BonemealEvent event) {
        proxy.boneMeal(event);
    }

    static {
        WARNING_LIMIT_TRACKER = new HashMap<String, Integer>();
    }
}

