/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import com.glektarssza.gtnh_customizer.utils.ExtendedWorld;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ExtinguishCommand
extends CommandBase {
    public static final int RANDOM_FIZZ_AUX_SFX_COMMAND = 1004;

    public String getCommandName() {
        return "extinguish";
    }

    public List<String> getCommandAliases() {
        return Collections.emptyList();
    }

    public String getCommandUsage(ICommandSender sender) {
        return new ChatComponentTranslation("gtnh_customizer.commands.extinguish.usage", new Object[]{String.format("%d", Minecraft.getMinecraft().gameSettings.renderDistanceChunks * 16)}).getFormattedText();
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        int index = args.length - 1;
        switch (index) {
            case 0: {
                return Arrays.asList("32", "~");
            }
            case 1: {
                return Collections.singletonList("~");
            }
            case 2: {
                return Collections.singletonList("~");
            }
            case 3: {
                return Collections.singletonList("~");
            }
            case 4: {
                return Collections.singletonList("~");
            }
            case 5: {
                return Collections.singletonList("~");
            }
        }
        return null;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        ChunkCoordinates coords;
        Integer radius = null;
        Long startingBlockXPos = null;
        Long startingBlockYPos = null;
        Long startingBlockZPos = null;
        Long endingBlockXPos = null;
        Long endingBlockYPos = null;
        Long endingBlockZPos = null;
        if (args.length <= 1) {
            if (args.length == 0) {
                radius = ((ExtendedWorld)sender.getEntityWorld()).getRenderDistance() * 16;
            } else {
                try {
                    radius = Integer.parseUnsignedInt(args[0], 10);
                }
                catch (NumberFormatException ex) {
                    throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.invalid_radius", new Object[]{String.format("%d", args[0])});
                }
            }
            coords = sender.getPlayerCoordinates();
            startingBlockXPos = coords.posX - radius;
            startingBlockYPos = coords.posY - radius;
            startingBlockZPos = coords.posZ - radius;
            endingBlockXPos = coords.posX + radius;
            endingBlockYPos = coords.posY + radius;
            endingBlockZPos = coords.posZ + radius;
        } else if (args.length == 6) {
            long temp;
            coords = sender.getPlayerCoordinates();
            startingBlockXPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[0], coords.posX);
            startingBlockYPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[1], coords.posY);
            startingBlockZPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[2], coords.posZ);
            endingBlockXPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[3], coords.posX);
            endingBlockYPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[4], coords.posY);
            endingBlockZPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[5], coords.posZ);
            if (endingBlockXPos < startingBlockXPos) {
                temp = startingBlockXPos;
                startingBlockXPos = endingBlockXPos;
                endingBlockXPos = temp;
            }
            if (endingBlockYPos < startingBlockYPos) {
                temp = startingBlockYPos;
                startingBlockYPos = endingBlockYPos;
                endingBlockYPos = temp;
            }
            if (endingBlockZPos < startingBlockZPos) {
                temp = startingBlockZPos;
                startingBlockZPos = endingBlockZPos;
                endingBlockZPos = temp;
            }
        } else {
            if (args.length < 6) {
                throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.not_enough_arguments", new Object[0]);
            }
            throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.wrong_usage", new Object[0]);
        }
        long volume = (endingBlockXPos - startingBlockXPos) * (endingBlockYPos - startingBlockYPos) * (endingBlockZPos - startingBlockZPos);
        if (volume > (long)Config.getExtinguishCommandMaxVolume()) {
            throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.volume_too_large", new Object[]{String.format("%d", volume), String.format("%d", Config.getExtinguishCommandMaxVolume())});
        }
        World world = sender.getEntityWorld();
        for (long x = startingBlockXPos.longValue(); x < endingBlockXPos; ++x) {
            for (long y = startingBlockYPos.longValue(); y < endingBlockYPos; ++y) {
                for (long z = startingBlockZPos.longValue(); z < endingBlockZPos; ++z) {
                    Block block = world.getBlock((int)x, (int)y, (int)z);
                    if (block != Blocks.fire) continue;
                    world.playAuxSFXAtEntity(null, 1004, (int)x, (int)y, (int)z, 0);
                    world.setBlockToAir((int)x, (int)y, (int)z);
                }
            }
        }
        sender.addChatMessage(new ChatComponentTranslation("gtnh_customizer.commands.extinguish.info.success", new Object[0]).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.GREEN).setItalic(Boolean.valueOf(true))));
        if (radius == null) {
            ExtinguishCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.extinguish.info.admin_notify.zone", (Object[])new Object[]{sender.getCommandSenderName(), String.format("%d", startingBlockXPos), String.format("%d", startingBlockYPos), String.format("%d", startingBlockZPos), String.format("%d", endingBlockXPos), String.format("%d", endingBlockYPos), String.format("%d", endingBlockZPos)});
        } else {
            ExtinguishCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.extinguish.info.admin_notify.radius", (Object[])new Object[]{sender.getCommandSenderName(), String.format("%d", radius)});
        }
    }
}

