/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.config;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.config.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public abstract class Category {
    protected final List<Category> childCategories = new ArrayList<Category>();
    protected final List<Property<?>> childProperties = new ArrayList();
    @Nullable
    protected final Category parent;

    public Category() {
        this(null);
    }

    public Category(@Nullable Category parent) {
        this.parent = parent;
    }

    @Nonnull
    public abstract String getID();

    @Nonnull
    public String getFullPath() {
        Category parent = this.getParent();
        if (parent == null) {
            return this.getID();
        }
        return String.join((CharSequence)".", parent.getFullPath(), this.getID());
    }

    @Nonnull
    public String getLanguageKey() {
        Category parent = this.getParent();
        if (parent == null) {
            return String.join((CharSequence)".", Config.LANG_KEY_CATEGORY_BASE, this.getID());
        }
        return String.join((CharSequence)".", parent.getLanguageKey(), this.getID());
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean getShowInGui() {
        return true;
    }

    public abstract boolean getRequiresWorldRestart();

    public abstract boolean getRequiresGameRestart();

    @Nullable
    public List<String> getPropertyOrder() {
        return null;
    }

    @Nullable
    public Category getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return !this.hasChildCategories() && !this.hasChildProperties();
    }

    public boolean hasChildCategories() {
        return !this.childCategories.isEmpty();
    }

    public boolean hasChildProperties() {
        return !this.childProperties.isEmpty();
    }

    @Nonnull
    public Category[] getChildrenCategories() {
        return this.childCategories.toArray(new Category[0]);
    }

    @Nonnull
    public Property<?>[] getChildrenProperties() {
        return this.childProperties.toArray(new Property[0]);
    }

    public void registerForgeConfigCategory(Configuration config) {
        this.registerForgeConfigCategory(config, true);
    }

    public Category registerForgeConfigCategory(Configuration config, boolean recurse) {
        ConfigCategory cat = config.getCategory(this.getFullPath());
        cat.setComment(this.getComment());
        cat.setLanguageKey(this.getLanguageKey());
        cat.setShowInGui(this.getShowInGui());
        cat.setRequiresWorldRestart(this.getRequiresWorldRestart());
        cat.setRequiresMcRestart(this.getRequiresGameRestart());
        List<String> order = this.getPropertyOrder();
        if (order != null) {
            cat.setPropertyOrder(order);
        }
        Arrays.stream(this.getChildrenProperties()).forEach(prop -> prop.registerForgeConfigCategory(config));
        if (recurse) {
            Arrays.stream(this.getChildrenCategories()).forEach(ccat -> ccat.registerForgeConfigCategory(config, true));
        }
        return this;
    }

    public Category loadValues(Configuration config) {
        Arrays.stream(this.getChildrenProperties()).forEach(prop -> prop.loadValue(config));
        Arrays.stream(this.getChildrenCategories()).forEach(prop -> prop.loadValues(config));
        return this;
    }
}

