/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityEnderman.class})
public class EntityEndermanMixin {
    @Inject(method={"findPlayerToAttack"}, at={@At(value="RETURN")}, cancellable=true)
    public void findPlayerToAttack$disableIfConfigured(CallbackInfoReturnable<Entity> cir) {
        Entity returnValue = (Entity)cir.getReturnValue();
        EntityPlayer player = null;
        if (returnValue instanceof EntityPlayer) {
            player = (EntityPlayer)returnValue;
        }
        if (player == null) {
            return;
        }
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"shouldAttackPlayer"}, at={@At(value="RETURN")}, cancellable=true)
    public void shouldAttackPlayer$disableIfConfigured(EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        if (player == null) {
            return;
        }
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"teleportTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void teleportTo$disableIfConfigured(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (Config.getPreventEnderMobTeleportation()) {
            cir.setReturnValue((Object)false);
        }
    }
}

