/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.late.specialmobs;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toast.specialMobs.entity.creeper.EntityEnderCreeper;

@Mixin(value={EntityEnderCreeper.class})
public class EntityEnderCreeperMixin {
    @Inject(method={"shouldAttackPlayer"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public void shouldAttackPlayer$disableIfConfigured(EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"teleportTo"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void teleportTo$disableIfConfigured(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (Config.getPreventEnderMobTeleportation()) {
            cir.setReturnValue((Object)false);
        }
    }
}

