/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.utils;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.config.Config;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerUtils {
    public static String getName(EntityPlayer player) {
        int i = GTNHCustomizer.getProxy().getWorld().playerEntities.indexOf(player);
        return PlayerUtils.getName(player, Optional.of(String.format("Player %d", i)));
    }

    public static String getName(EntityPlayer player, Optional<String> fallback) {
        GameProfile playerProfile = player.getGameProfile();
        if (playerProfile != null) {
            return playerProfile.getName();
        }
        return fallback.orElseGet(() -> {
            int i = GTNHCustomizer.getProxy().getWorld().playerEntities.indexOf(player);
            return String.format("Player %d", i);
        });
    }

    public static boolean getIsPlayerGloballyImmune(EntityPlayer player) {
        GameProfile playerProfile = player.getGameProfile();
        UUID playerUUID = playerProfile == null ? null : EntityPlayer.func_146094_a((GameProfile)playerProfile);
        String nameFallback = PlayerUtils.getName(player, Optional.of(player.getDisplayName()));
        return Arrays.asList(Config.getGloballyImmunePlayers()).stream().anyMatch(item -> playerUUID != null && item.equalsIgnoreCase(playerUUID.toString()) || item.equalsIgnoreCase(nameFallback));
    }

    public static NBTTagCompound getPlayerModData(EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        if (!playerData.hasKey("gtnh_customizer", 10)) {
            return new NBTTagCompound();
        }
        return (NBTTagCompound)playerData.getTag("gtnh_customizer");
    }
}

