/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.config;

import com.glektarssza.gtnh_customizer.config.Category;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class Property<T> {
    protected Category parent;

    public Property(Category parent) {
        this.parent = parent;
    }

    @Nonnull
    public abstract String getID();

    @Nonnull
    public String getFullPath() {
        return String.join((CharSequence)".", this.getParent().getFullPath(), this.getID());
    }

    @Nonnull
    public String getLanguageKey() {
        return String.join((CharSequence)".", this.getParent().getLanguageKey(), this.getID());
    }

    @Nonnull
    public String getComment() {
        return "";
    }

    public boolean getShowInGui() {
        return true;
    }

    public boolean getRequiresWorldRestart() {
        return false;
    }

    public boolean getRequiresGameRestart() {
        return false;
    }

    @Nonnull
    public abstract Property.Type getValueType();

    public boolean isList() {
        return false;
    }

    public boolean isFixedLengthList() {
        return false;
    }

    public int getMaxListLength() {
        return -1;
    }

    public int getMinIntValue() {
        return Integer.MIN_VALUE;
    }

    public int getMaxIntValue() {
        return Integer.MAX_VALUE;
    }

    public double getMinDoubleValue() {
        return Double.MIN_VALUE;
    }

    public double getMaxDoubleValue() {
        return Double.MAX_VALUE;
    }

    @Nonnull
    public abstract T getDefaultValue();

    @Nonnull
    public Category getParent() {
        return this.parent;
    }

    public void registerForgeConfigCategory(Configuration config) {
        net.minecraftforge.common.config.Property prop;
        switch (this.getValueType()) {
            case BOOLEAN: {
                if (this.isList()) {
                    prop = config.get(this.getParent().getFullPath(), this.getID(), (boolean[])this.getDefaultValue(), this.getComment());
                    break;
                }
                prop = config.get(this.getParent().getFullPath(), this.getID(), ((Boolean)this.getDefaultValue()).booleanValue(), this.getComment());
                break;
            }
            case COLOR: 
            case MOD_ID: 
            case STRING: {
                if (this.isList()) {
                    prop = config.get(this.getParent().getFullPath(), this.getID(), (String[])this.getDefaultValue(), this.getComment(), this.getValueType());
                    break;
                }
                prop = config.get(this.getParent().getFullPath(), this.getID(), (String)this.getDefaultValue(), this.getComment(), this.getValueType());
                break;
            }
            case DOUBLE: {
                prop = this.isList() ? config.get(this.getParent().getFullPath(), this.getID(), (double[])this.getDefaultValue(), this.getComment()) : config.get(this.getParent().getFullPath(), this.getID(), ((Double)this.getDefaultValue()).doubleValue(), this.getComment());
                prop.setMinValue(this.getMinDoubleValue());
                prop.setMaxValue(this.getMaxDoubleValue());
                break;
            }
            case INTEGER: {
                prop = this.isList() ? config.get(this.getParent().getFullPath(), this.getID(), (int[])this.getDefaultValue(), this.getComment()) : config.get(this.getParent().getFullPath(), this.getID(), ((Integer)this.getDefaultValue()).intValue(), this.getComment());
                prop.setMinValue(this.getMinIntValue());
                prop.setMaxValue(this.getMaxIntValue());
                break;
            }
            default: {
                return;
            }
        }
        prop.setLanguageKey(this.getLanguageKey());
        prop.setShowInGui(this.getShowInGui());
        prop.setRequiresWorldRestart(this.getRequiresWorldRestart());
        prop.setRequiresMcRestart(this.getRequiresGameRestart());
        prop.setIsListLengthFixed(this.isFixedLengthList());
        if (this.isList() && this.getMaxListLength() > 0) {
            prop.setMaxListLength(this.getMaxListLength());
        }
    }

    public abstract void loadValue(Configuration var1);
}

