/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.utils;

import com.glektarssza.gtnh_customizer.utils.exceptions.NumberOutOfRangeException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public final class CommandUtils {
    public static final int PERMISSION_NONE = 0;
    public static final int PERMISSION_MODERATOR = 1;
    public static final int PERMISSION_GAMEMASTER = 2;
    public static final int PERMISSION_ADMIN = 3;
    public static final int PERMISSION_OWNER = 4;
    private static final Pattern BOOLEAN_MATCHER = Pattern.compile("true|false|1|0", 2);
    private static final Pattern BYTE_MATCHER = Pattern.compile("-?\\d{1,3}");
    private static final Pattern SHORT_MATCHER = Pattern.compile("-?\\d{1,5}");
    private static final Pattern INTEGER_MATCHER = Pattern.compile("-?\\d{1,10}");
    private static final Pattern LONG_MATCHER = Pattern.compile("-?\\d{1,19}");
    private static final Pattern FLOAT_MATCHER = Pattern.compile("-?\\d+(\\.\\d*)?");
    private static final Pattern DOUBLE_MATCHER = Pattern.compile("-?\\d+(\\.\\d*)?");
    private static final Pattern NUMERIC_MATCHER = Pattern.compile("-?\\d+(\\.\\d*)?");
    private static final Pattern COORDINATE_MATCHER = Pattern.compile("(~(-?\\d+(\\.\\d*)?)?)|(-?\\d+(\\.\\d*)?)");
    private static final Pattern RELATIVE_COORDINATE_MATCHER = Pattern.compile("~(-?\\d+(\\.\\d*)?)?");

    public static boolean isBooleanArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return BOOLEAN_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isByteArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return BYTE_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isShortArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return SHORT_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isIntegerArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return INTEGER_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isFloatArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return FLOAT_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isDoubleArgument(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return DOUBLE_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isNumericArgument(String[] args, int index) {
        return NUMERIC_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isCoordinateArgument(String[] args, int index) {
        return COORDINATE_MATCHER.matcher(args[index]).matches();
    }

    public static boolean isRelativeCoordinateArgument(String[] args, int index) {
        return RELATIVE_COORDINATE_MATCHER.matcher(args[index]).matches();
    }

    public static String[] getAllPlayerUsernames() {
        return MinecraftServer.func_71276_C().func_71203_ab().func_72369_d();
    }

    public static List<String> getAllPlayerUsernamesIterable() {
        return Arrays.asList(MinecraftServer.func_71276_C().func_71203_ab().func_72369_d());
    }

    public static String[] getTruncatedPlayerUsernameList(int limit) {
        return (String[])Arrays.stream(CommandUtils.getAllPlayerUsernames()).limit(limit).toArray();
    }

    public static List<String> getTruncatedPlayerUsernameIterable(int limit) {
        return Arrays.stream(CommandUtils.getAllPlayerUsernames()).limit(limit).collect(Collectors.toList());
    }

    public static Integer[] getAllDimensionIDs() {
        return DimensionManager.getIDs();
    }

    public static List<Integer> getAllDimensionIDsIterable() {
        return Arrays.asList(DimensionManager.getIDs());
    }

    public static Integer[] getTruncatedDimensionIDsList(int limit) {
        return (Integer[])Arrays.stream(CommandUtils.getAllDimensionIDs()).limit(limit).toArray(Integer[]::new);
    }

    public static List<Integer> getTruncatedDimensionIDsIterable(int limit) {
        return Arrays.stream(CommandUtils.getAllDimensionIDs()).limit(limit).collect(Collectors.toList());
    }

    public static String[] getAllDimensionNames() {
        return (String[])CommandUtils.getAllDimensionIDsIterable().parallelStream().map(id -> DimensionManager.getProvider((int)id).func_80007_l()).toArray();
    }

    public static List<String> getAllDimensionNamesIterable() {
        return CommandUtils.getAllDimensionIDsIterable().parallelStream().map(id -> DimensionManager.getProvider((int)id).func_80007_l()).collect(Collectors.toList());
    }

    public static String[] getTruncatedDimensionNamesList(int limit) {
        return (String[])CommandUtils.getTruncatedDimensionIDsIterable(limit).parallelStream().map(id -> DimensionManager.getProvider((int)id).func_80007_l()).toArray();
    }

    public static List<String> getTruncatedDimensionNamesIterable(int limit) {
        return CommandUtils.getTruncatedDimensionIDsIterable(limit).parallelStream().map(id -> DimensionManager.getProvider((int)id).func_80007_l()).collect(Collectors.toList());
    }

    public static int findDimensionIDFromName(String name) {
        return CommandUtils.getAllDimensionIDsIterable().stream().map((Function<Integer, WorldProvider>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findDimensionIDFromName$5(java.lang.Integer ), (Ljava/lang/Integer;)Lnet/minecraft/world/WorldProvider;)()).filter((Predicate<WorldProvider>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findDimensionIDFromName$6(java.lang.String net.minecraft.world.WorldProvider ), (Lnet/minecraft/world/WorldProvider;)Z)((String)name)).findFirst().orElseThrow((Supplier<NoSuchElementException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$findDimensionIDFromName$7(), ()Ljava/util/NoSuchElementException;)()).field_76574_g;
    }

    public static byte parseByteArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseByteArgument(sender, arg, 10);
    }

    public static byte parseByteArgument(ICommandSender sender, String arg, int radix) throws NumberFormatException {
        if (!INTEGER_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of an integer", arg));
        }
        return Byte.parseByte(arg, radix);
    }

    public static byte parseByteArgument(ICommandSender sender, String arg, byte min, byte max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseByteArgument(sender, arg, 10, min, max);
    }

    public static byte parseByteArgument(ICommandSender sender, String arg, int radix, byte min, byte max) throws NumberFormatException, NumberOutOfRangeException {
        byte result = CommandUtils.parseByteArgument(sender, arg, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static byte parseOptionalByteArgument(ICommandSender sender, String arg, byte defaultValue) {
        try {
            return CommandUtils.parseByteArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static byte parseOptionalByteArgument(ICommandSender sender, String arg, int radix, byte defaultValue) {
        try {
            return CommandUtils.parseByteArgument(sender, arg, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static byte parseOptionalByteArgument(ICommandSender sender, String arg, byte min, byte max, byte defaultValue) {
        return CommandUtils.parseOptionalByteArgument(sender, arg, 10, min, max, defaultValue);
    }

    public static byte parseOptionalByteArgument(ICommandSender sender, String arg, int radix, byte min, byte max, byte defaultValue) {
        try {
            return CommandUtils.parseByteArgument(sender, arg, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static byte parseBlockRelativeByteArgument(ICommandSender sender, String arg, byte baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeByteArgument(sender, arg, baseValue, 10);
    }

    public static byte parseBlockRelativeByteArgument(ICommandSender sender, String arg, byte baseValue, int radix) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseByteArgument(sender, arg, radix);
        }
        byte offset = arg.length() == 1 ? (byte)0 : CommandUtils.parseByteArgument(sender, arg.substring(1), radix);
        return (byte)(baseValue + offset);
    }

    public static byte parseBlockRelativeByteArgument(ICommandSender sender, String arg, byte baseValue, byte min, byte max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeByteArgument(sender, arg, baseValue, 10, min, max);
    }

    public static byte parseBlockRelativeByteArgument(ICommandSender sender, String arg, byte baseValue, int radix, byte min, byte max) throws NumberFormatException {
        byte result = CommandUtils.parseBlockRelativeByteArgument(sender, arg, baseValue, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static byte parseBlockRelativeOptionalByteArgument(ICommandSender sender, String arg, byte baseValue, byte defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalByteArgument(sender, arg, baseValue, 10, defaultValue);
    }

    public static byte parseBlockRelativeOptionalByteArgument(ICommandSender sender, String arg, byte baseValue, int radix, byte defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeByteArgument(sender, arg, baseValue, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static byte parseBlockRelativeOptionalByteArgument(ICommandSender sender, String arg, byte baseValue, byte min, byte max, byte defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalByteArgument(sender, arg, baseValue, 10, min, max, defaultValue);
    }

    public static byte parseBlockRelativeOptionalByteArgument(ICommandSender sender, String arg, byte baseValue, int radix, byte min, byte max, byte defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeByteArgument(sender, arg, baseValue, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static short parseShortArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseShortArgument(sender, arg, 10);
    }

    public static short parseShortArgument(ICommandSender sender, String arg, int radix) throws NumberFormatException {
        if (!SHORT_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of an integer", arg));
        }
        return Short.parseShort(arg, radix);
    }

    public static short parseShortArgument(ICommandSender sender, String arg, short min, short max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseShortArgument(sender, arg, 10, min, max);
    }

    public static short parseShortArgument(ICommandSender sender, String arg, int radix, short min, short max) throws NumberFormatException, NumberOutOfRangeException {
        short result = CommandUtils.parseShortArgument(sender, arg, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static short parseOptionalShortArgument(ICommandSender sender, String arg, short defaultValue) {
        try {
            return CommandUtils.parseShortArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static short parseOptionalShortArgument(ICommandSender sender, String arg, int radix, short defaultValue) {
        try {
            return CommandUtils.parseShortArgument(sender, arg, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static short parseOptionalShortArgument(ICommandSender sender, String arg, short min, short max, short defaultValue) {
        return CommandUtils.parseOptionalShortArgument(sender, arg, 10, min, max, defaultValue);
    }

    public static short parseOptionalShortArgument(ICommandSender sender, String arg, int radix, short min, short max, short defaultValue) {
        try {
            return CommandUtils.parseShortArgument(sender, arg, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static short parseBlockRelativeShortArgument(ICommandSender sender, String arg, short baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeShortArgument(sender, arg, baseValue, 10);
    }

    public static short parseBlockRelativeShortArgument(ICommandSender sender, String arg, short baseValue, int radix) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseShortArgument(sender, arg, radix);
        }
        short offset = arg.length() == 1 ? (short)0 : CommandUtils.parseShortArgument(sender, arg.substring(1), radix);
        return (short)(baseValue + offset);
    }

    public static short parseBlockRelativeShortArgument(ICommandSender sender, String arg, short baseValue, short min, short max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeShortArgument(sender, arg, baseValue, 10, min, max);
    }

    public static short parseBlockRelativeShortArgument(ICommandSender sender, String arg, short baseValue, int radix, short min, short max) throws NumberFormatException {
        short result = CommandUtils.parseBlockRelativeShortArgument(sender, arg, baseValue, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static short parseBlockRelativeOptionalShortArgument(ICommandSender sender, String arg, short baseValue, short defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalShortArgument(sender, arg, baseValue, 10, defaultValue);
    }

    public static short parseBlockRelativeOptionalShortArgument(ICommandSender sender, String arg, short baseValue, int radix, short defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeShortArgument(sender, arg, baseValue, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static short parseBlockRelativeOptionalShortArgument(ICommandSender sender, String arg, short baseValue, short min, short max, short defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalShortArgument(sender, arg, baseValue, 10, min, max, defaultValue);
    }

    public static short parseBlockRelativeOptionalShortArgument(ICommandSender sender, String arg, short baseValue, int radix, short min, short max, short defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeShortArgument(sender, arg, baseValue, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static int parseIntegerArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseIntegerArgument(sender, arg, 10);
    }

    public static int parseIntegerArgument(ICommandSender sender, String arg, int radix) throws NumberFormatException {
        if (!INTEGER_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of an integer", arg));
        }
        return Integer.parseInt(arg, radix);
    }

    public static int parseIntegerArgument(ICommandSender sender, String arg, int min, int max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseIntegerArgument(sender, arg, 10, min, max);
    }

    public static int parseIntegerArgument(ICommandSender sender, String arg, int radix, int min, int max) throws NumberFormatException, NumberOutOfRangeException {
        int result = CommandUtils.parseIntegerArgument(sender, arg, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static int parseOptionalIntegerArgument(ICommandSender sender, String arg, int defaultValue) {
        try {
            return CommandUtils.parseIntegerArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static int parseOptionalIntegerArgument(ICommandSender sender, String arg, int radix, int defaultValue) {
        try {
            return CommandUtils.parseIntegerArgument(sender, arg, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static int parseOptionalIntegerArgument(ICommandSender sender, String arg, int min, int max, int defaultValue) {
        return CommandUtils.parseOptionalIntegerArgument(sender, arg, 10, min, max, defaultValue);
    }

    public static int parseOptionalIntegerArgument(ICommandSender sender, String arg, int radix, int min, int max, int defaultValue) {
        try {
            return CommandUtils.parseIntegerArgument(sender, arg, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static int parseBlockRelativeIntegerArgument(ICommandSender sender, String arg, int baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeIntegerArgument(sender, arg, baseValue, 10);
    }

    public static int parseBlockRelativeIntegerArgument(ICommandSender sender, String arg, int baseValue, int radix) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseIntegerArgument(sender, arg, radix);
        }
        int offset = arg.length() == 1 ? 0 : CommandUtils.parseIntegerArgument(sender, arg.substring(1), radix);
        return baseValue + offset;
    }

    public static int parseBlockRelativeIntegerArgument(ICommandSender sender, String arg, int baseValue, int min, int max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeIntegerArgument(sender, arg, baseValue, 10, min, max);
    }

    public static int parseBlockRelativeIntegerArgument(ICommandSender sender, String arg, int baseValue, int radix, int min, int max) throws NumberFormatException {
        int result = CommandUtils.parseBlockRelativeIntegerArgument(sender, arg, baseValue, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static int parseBlockRelativeOptionalIntegerArgument(ICommandSender sender, String arg, int baseValue, int defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalIntegerArgument(sender, arg, baseValue, 10, defaultValue);
    }

    public static int parseBlockRelativeOptionalIntegerArgument(ICommandSender sender, String arg, int baseValue, int radix, int defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeIntegerArgument(sender, arg, baseValue, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static int parseBlockRelativeOptionalIntegerArgument(ICommandSender sender, String arg, int baseValue, int min, int max, int defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalIntegerArgument(sender, arg, baseValue, 10, min, max, defaultValue);
    }

    public static int parseBlockRelativeOptionalIntegerArgument(ICommandSender sender, String arg, int baseValue, int radix, int min, int max, int defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeIntegerArgument(sender, arg, baseValue, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static long parseLongArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseLongArgument(sender, arg, 10);
    }

    public static long parseLongArgument(ICommandSender sender, String arg, int radix) throws NumberFormatException {
        if (!LONG_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of an long", arg));
        }
        return Long.parseLong(arg, radix);
    }

    public static long parseLongArgument(ICommandSender sender, String arg, int min, int max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseLongArgument(sender, arg, 10, min, max);
    }

    public static long parseLongArgument(ICommandSender sender, String arg, int radix, long min, long max) throws NumberFormatException, NumberOutOfRangeException {
        long result = CommandUtils.parseLongArgument(sender, arg, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static long parseOptionalLongArgument(ICommandSender sender, String arg, long defaultValue) {
        try {
            return CommandUtils.parseLongArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static long parseOptionalLongArgument(ICommandSender sender, String arg, int radix, long defaultValue) {
        try {
            return CommandUtils.parseLongArgument(sender, arg, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static long parseOptionalLongArgument(ICommandSender sender, String arg, long min, long max, long defaultValue) {
        return CommandUtils.parseOptionalLongArgument(sender, arg, 10, min, max, defaultValue);
    }

    public static long parseOptionalLongArgument(ICommandSender sender, String arg, int radix, long min, long max, long defaultValue) {
        try {
            return CommandUtils.parseLongArgument(sender, arg, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static long parseBlockRelativeLongArgument(ICommandSender sender, String arg, long baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeLongArgument(sender, arg, baseValue, 10);
    }

    public static long parseBlockRelativeLongArgument(ICommandSender sender, String arg, long baseValue, int radix) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseLongArgument(sender, arg, radix);
        }
        long offset = arg.length() == 1 ? 0L : CommandUtils.parseLongArgument(sender, arg.substring(1), radix);
        return baseValue + offset;
    }

    public static long parseBlockRelativeLongArgument(ICommandSender sender, String arg, long baseValue, long min, long max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeLongArgument(sender, arg, baseValue, 10, min, max);
    }

    public static long parseBlockRelativeLongArgument(ICommandSender sender, String arg, long baseValue, int radix, long min, long max) throws NumberFormatException {
        long result = CommandUtils.parseBlockRelativeLongArgument(sender, arg, baseValue, radix);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static long parseBlockRelativeOptionalLongArgument(ICommandSender sender, String arg, long baseValue, long defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalLongArgument(sender, arg, baseValue, 10, defaultValue);
    }

    public static long parseBlockRelativeOptionalLongArgument(ICommandSender sender, String arg, long baseValue, int radix, long defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeLongArgument(sender, arg, baseValue, radix);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static long parseBlockRelativeOptionalLongArgument(ICommandSender sender, String arg, long baseValue, long min, long max, long defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalLongArgument(sender, arg, baseValue, 10, min, max, defaultValue);
    }

    public static long parseBlockRelativeOptionalLongArgument(ICommandSender sender, String arg, long baseValue, int radix, long min, long max, long defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeLongArgument(sender, arg, baseValue, radix, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static float parseFloatArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseFloatArgument(sender, arg, false);
    }

    public static float parseFloatArgument(ICommandSender sender, String arg, boolean centerToBlock) throws NumberFormatException {
        if (!FLOAT_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of a float", arg));
        }
        return Float.parseFloat(arg) + (centerToBlock ? 0.5f : 0.0f);
    }

    public static float parseFloatArgument(ICommandSender sender, String arg, float min, float max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseFloatArgument(sender, arg, false, min, max);
    }

    public static float parseFloatArgument(ICommandSender sender, String arg, boolean centerToBlock, float min, float max) throws NumberFormatException, NumberOutOfRangeException {
        float result = CommandUtils.parseFloatArgument(sender, arg, centerToBlock);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static float parseOptionalFloatArgument(ICommandSender sender, String arg, float defaultValue) {
        try {
            return CommandUtils.parseFloatArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static float parseOptionalFloatArgument(ICommandSender sender, String arg, boolean centerToBlock, float defaultValue) {
        try {
            return CommandUtils.parseFloatArgument(sender, arg, centerToBlock);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static float parseOptionalFloatArgument(ICommandSender sender, String arg, float min, float max, float defaultValue) {
        return CommandUtils.parseOptionalFloatArgument(sender, arg, false, min, max, defaultValue);
    }

    public static float parseOptionalFloatArgument(ICommandSender sender, String arg, boolean centerToBlock, float min, float max, float defaultValue) {
        try {
            return CommandUtils.parseFloatArgument(sender, arg, centerToBlock, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static float parseBlockRelativeFloatArgument(ICommandSender sender, String arg, float baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeFloatArgument(sender, arg, baseValue, false);
    }

    public static float parseBlockRelativeFloatArgument(ICommandSender sender, String arg, float baseValue, boolean centerToBlock) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseFloatArgument(sender, arg) + (centerToBlock ? 0.5f : 0.0f);
        }
        float offset = arg.length() == 1 ? 0.0f : CommandUtils.parseFloatArgument(sender, arg.substring(1));
        return baseValue + offset + (centerToBlock ? 0.5f : 0.0f);
    }

    public static float parseBlockRelativeFloatArgument(ICommandSender sender, String arg, float baseValue, float min, float max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeFloatArgument(sender, arg, baseValue, false, min, max);
    }

    public static float parseBlockRelativeFloatArgument(ICommandSender sender, String arg, float baseValue, boolean centerToBlock, float min, float max) throws NumberFormatException {
        float result = CommandUtils.parseBlockRelativeFloatArgument(sender, arg, baseValue, centerToBlock);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static float parseBlockRelativeOptionalFloatArgument(ICommandSender sender, String arg, float baseValue, float defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalFloatArgument(sender, arg, baseValue, false, defaultValue);
    }

    public static float parseBlockRelativeOptionalFloatArgument(ICommandSender sender, String arg, float baseValue, boolean centerToBlock, float defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeFloatArgument(sender, arg, baseValue, centerToBlock);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static float parseBlockRelativeOptionalFloatArgument(ICommandSender sender, String arg, float baseValue, float min, float max, float defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalFloatArgument(sender, arg, baseValue, false, min, max, defaultValue);
    }

    public static float parseBlockRelativeOptionalFloatArgument(ICommandSender sender, String arg, float baseValue, boolean centerToBlock, float min, float max, float defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeFloatArgument(sender, arg, baseValue, centerToBlock, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static double parseDoubleArgument(ICommandSender sender, String arg) throws NumberFormatException {
        return CommandUtils.parseDoubleArgument(sender, arg, false);
    }

    public static double parseDoubleArgument(ICommandSender sender, String arg, boolean centerToBlock) throws NumberFormatException {
        if (!DOUBLE_MATCHER.matcher(arg).matches()) {
            throw new NumberFormatException(String.format("Value '%s' does not match the format of a double", arg));
        }
        return Double.parseDouble(arg) + (double)(centerToBlock ? 0.5f : 0.0f);
    }

    public static double parseDoubleArgument(ICommandSender sender, String arg, double min, double max) throws NumberFormatException, NumberOutOfRangeException {
        return CommandUtils.parseDoubleArgument(sender, arg, false, min, max);
    }

    public static double parseDoubleArgument(ICommandSender sender, String arg, boolean centerToBlock, double min, double max) throws NumberFormatException, NumberOutOfRangeException {
        double result = CommandUtils.parseDoubleArgument(sender, arg, centerToBlock);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static double parseOptionalDoubleArgument(ICommandSender sender, String arg, double defaultValue) {
        try {
            return CommandUtils.parseDoubleArgument(sender, arg);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static double parseOptionalDoubleArgument(ICommandSender sender, String arg, boolean centerToBlock, double defaultValue) {
        try {
            return CommandUtils.parseDoubleArgument(sender, arg, centerToBlock);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static double parseOptionalDoubleArgument(ICommandSender sender, String arg, double min, double max, double defaultValue) {
        return CommandUtils.parseOptionalDoubleArgument(sender, arg, false, min, max, defaultValue);
    }

    public static double parseOptionalDoubleArgument(ICommandSender sender, String arg, boolean centerToBlock, double min, double max, double defaultValue) {
        try {
            return CommandUtils.parseDoubleArgument(sender, arg, centerToBlock, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    public static double parseBlockRelativeDoubleArgument(ICommandSender sender, String arg, double baseValue) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeDoubleArgument(sender, arg, baseValue, false);
    }

    public static double parseBlockRelativeDoubleArgument(ICommandSender sender, String arg, double baseValue, boolean centerToBlock) throws NumberFormatException {
        if (!arg.startsWith("~")) {
            return CommandUtils.parseDoubleArgument(sender, arg) + (double)(centerToBlock ? 0.5f : 0.0f);
        }
        double offset = arg.length() == 1 ? 0.0 : CommandUtils.parseDoubleArgument(sender, arg.substring(1));
        return baseValue + offset + (double)(centerToBlock ? 0.5f : 0.0f);
    }

    public static double parseBlockRelativeDoubleArgument(ICommandSender sender, String arg, double baseValue, double min, double max) throws NumberFormatException {
        return CommandUtils.parseBlockRelativeDoubleArgument(sender, arg, baseValue, false, min, max);
    }

    public static double parseBlockRelativeDoubleArgument(ICommandSender sender, String arg, double baseValue, boolean centerToBlock, double min, double max) throws NumberFormatException {
        double result = CommandUtils.parseBlockRelativeDoubleArgument(sender, arg, baseValue, centerToBlock);
        if (result < min || result > max) {
            throw new NumberOutOfRangeException(result, min, max);
        }
        return result;
    }

    public static double parseBlockRelativeOptionalDoubleArgument(ICommandSender sender, String arg, double baseValue, double defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalDoubleArgument(sender, arg, baseValue, false, defaultValue);
    }

    public static double parseBlockRelativeOptionalDoubleArgument(ICommandSender sender, String arg, double baseValue, boolean centerToBlock, double defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeDoubleArgument(sender, arg, baseValue, centerToBlock);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
    }

    public static double parseBlockRelativeOptionalDoubleArgument(ICommandSender sender, String arg, double baseValue, double min, double max, double defaultValue) {
        return CommandUtils.parseBlockRelativeOptionalDoubleArgument(sender, arg, baseValue, false, min, max, defaultValue);
    }

    public static double parseBlockRelativeOptionalDoubleArgument(ICommandSender sender, String arg, double baseValue, boolean centerToBlock, double min, double max, double defaultValue) {
        try {
            return CommandUtils.parseBlockRelativeDoubleArgument(sender, arg, baseValue, centerToBlock, min, max);
        }
        catch (NumberFormatException t) {
            return defaultValue;
        }
        catch (NumberOutOfRangeException t) {
            return defaultValue;
        }
    }

    private static /* synthetic */ NoSuchElementException lambda$findDimensionIDFromName$7() {
        return new NoSuchElementException();
    }

    private static /* synthetic */ boolean lambda$findDimensionIDFromName$6(String name, WorldProvider provider) {
        return provider.func_80007_l().equals(name);
    }

    private static /* synthetic */ WorldProvider lambda$findDimensionIDFromName$5(Integer id) {
        return DimensionManager.getProvider((int)id);
    }
}

