/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.config;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.config.MigrationUtils;
import com.glektarssza.gtnh_customizer.config.categories.Commands;
import com.glektarssza.gtnh_customizer.config.categories.Debugging;
import com.glektarssza.gtnh_customizer.config.categories.Gameplay;
import com.glektarssza.gtnh_customizer.utils.ImmutableTuple;
import com.glektarssza.gtnh_customizer.utils.exceptions.KeyAlreadyExistsException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static String CONFIG_VERSION = "9";
    public static String LANG_KEY_BASE = "gtnh_customizer.config";
    public static String LANG_KEY_CATEGORY_BASE = String.join((CharSequence)".", LANG_KEY_BASE, "categories");
    private static Configuration CONFIG_INSTANCE;
    private static final Map<String, ImmutableTuple<String, Consumer<Configuration>>> MIGRATIONS;
    private static final List<String> globallyImmunePlayers;
    private static boolean preventEnderMobTeleport;
    private static boolean repairCommandIgnoresLiquids;
    private static boolean tconstructCanBoneMealSlimeSaplings;
    private static boolean thaumcraftCanBoneMealGreatwoodSaplings;
    private static boolean thaumcraftCanBoneMealSilverwoodSaplings;
    private static int extinguishCommandMaxVolume;
    private static boolean verboseLoggingEnabled;
    public static UUID CONFIG_ID;

    public static String[] getGloballyImmunePlayers() {
        String[] ret = new String[globallyImmunePlayers.size()];
        globallyImmunePlayers.toArray(ret);
        return ret;
    }

    public static void setImmunePlayers(String[] players) {
        Config.clearImmunePlayers();
        globallyImmunePlayers.addAll(Arrays.asList(players));
    }

    public static void clearImmunePlayers() {
        globallyImmunePlayers.clear();
    }

    public static void resetImmunePlayers() {
        Config.clearImmunePlayers();
    }

    public static boolean getPreventEnderMobTeleportation() {
        return preventEnderMobTeleport;
    }

    public static void setPreventEnderMobTeleportation(boolean value) {
        preventEnderMobTeleport = value;
    }

    public static void resetPreventEnderMobTeleportation() {
        Config.setPreventEnderMobTeleportation(true);
    }

    public static void togglePreventEnderMobTeleportation() {
        Config.setPreventEnderMobTeleportation(!Config.getPreventEnderMobTeleportation());
    }

    public static boolean getTConstructCanBoneMealSlimeSaplings() {
        return tconstructCanBoneMealSlimeSaplings;
    }

    public static void setTConstructCanBoneMealSlimeSaplings(boolean value) {
        tconstructCanBoneMealSlimeSaplings = value;
    }

    public static void resetTConstructCanBoneMealSlimeSaplings() {
        Config.setTConstructCanBoneMealSlimeSaplings(true);
    }

    public static void toggleTConstructCanBoneMealSlimeSaplings() {
        Config.setTConstructCanBoneMealSlimeSaplings(!Config.getTConstructCanBoneMealSlimeSaplings());
    }

    public static boolean getThaumcraftCanBoneMealGreatwoodSaplings() {
        return thaumcraftCanBoneMealGreatwoodSaplings;
    }

    public static void setThaumcraftCanBoneMealGreatwoodSaplings(boolean value) {
        thaumcraftCanBoneMealGreatwoodSaplings = value;
    }

    public static void resetThaumcraftCanBoneMealGreatwoodSaplings() {
        Config.setThaumcraftCanBoneMealGreatwoodSaplings(true);
    }

    public static void toggleThaumcraftCanBoneMealGreatwoodSaplings() {
        Config.setThaumcraftCanBoneMealGreatwoodSaplings(!Config.getThaumcraftCanBoneMealGreatwoodSaplings());
    }

    public static boolean getThaumcraftCanBoneMealSilverwoodSaplings() {
        return thaumcraftCanBoneMealSilverwoodSaplings;
    }

    public static void setThaumcraftCanBoneMealSilverwoodSaplings(boolean value) {
        thaumcraftCanBoneMealSilverwoodSaplings = value;
    }

    public static void resetThaumcraftCanBoneMealSilverwoodSaplings() {
        Config.setThaumcraftCanBoneMealSilverwoodSaplings(true);
    }

    public static void toggleThaumcraftCanBoneMealSilverwoodSaplings() {
        Config.setThaumcraftCanBoneMealSilverwoodSaplings(!Config.getThaumcraftCanBoneMealSilverwoodSaplings());
    }

    public static boolean getRepairCommandRaycastIgnoresLiquids() {
        return repairCommandIgnoresLiquids;
    }

    public static void setRepairCommandRaycastIgnoresLiquids(boolean value) {
        repairCommandIgnoresLiquids = value;
    }

    public static void resetRepairCommandRaycastIgnoresLiquids() {
        Config.setRepairCommandRaycastIgnoresLiquids(false);
    }

    public static void toggleRepairCommandRaycastIgnoresLiquids() {
        Config.setRepairCommandRaycastIgnoresLiquids(!Config.getRepairCommandRaycastIgnoresLiquids());
    }

    public static int getExtinguishCommandMaxVolume() {
        return extinguishCommandMaxVolume;
    }

    public static void setExtinguishCommandMaxVolume(int value) {
        extinguishCommandMaxVolume = value;
    }

    public static void resetExtinguishCommandMaxVolume() {
        Config.setExtinguishCommandMaxVolume(Integer.MAX_VALUE);
    }

    public static boolean getVerboseLoggingEnabled() {
        return verboseLoggingEnabled;
    }

    public static void setVerboseLoggingEnabled(boolean value) {
        verboseLoggingEnabled = value;
    }

    public static void resetVerboseLoggingEnabled() {
        Config.setVerboseLoggingEnabled(false);
    }

    public static void toggleVerboseLoggingEnabled() {
        Config.setVerboseLoggingEnabled(!Config.getVerboseLoggingEnabled());
    }

    public static List<ConfigCategory> getTopLevelCategories() {
        if (CONFIG_INSTANCE == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigCategory> list = new ArrayList<ConfigCategory>();
        ArrayList<String> children = new ArrayList<String>();
        for (String name : CONFIG_INSTANCE.getCategoryNames()) {
            if (Config.CONFIG_INSTANCE.getCategory((String)name).parent != null) continue;
            children.add(name);
        }
        for (String category : children) {
            if (category.contains(".")) continue;
            list.add(CONFIG_INSTANCE.getCategory(category));
        }
        return list;
    }

    public static void init(File configDir, String fileName) throws KeyAlreadyExistsException, NoSuchElementException {
        Config.registerMigration("1", "2", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, "general.immunePlayers")) {
                MigrationUtils.renameProperty(configInstance, "general.immunePlayers", "globallyImmunePlayers");
            }
        });
        Config.registerMigration("2", "3", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, "general.globallyImmunePlayers")) {
                MigrationUtils.renameProperty(configInstance, "general.globallyImmunePlayers", "globally_immune_players");
            }
        });
        Config.registerMigration("5", "6", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, "general.globally_immune_players")) {
                configInstance.setCategoryComment("gameplay", "Gameplay-related tweaks").setCategoryLanguageKey("gameplay", "gtnh_customizer.config.category_gameplay").setCategoryRequiresMcRestart("gameplay", false).setCategoryRequiresMcRestart("gameplay", false);
                MigrationUtils.moveProperty(configInstance, "general.globally_immune_players", "gameplay");
                if (configInstance.getCategory("general").isEmpty()) {
                    configInstance.removeCategory(configInstance.getCategory("general"));
                }
            }
            if (MigrationUtils.hasPropertyByPath(configInstance, "command.repair_ignores_liquids")) {
                MigrationUtils.renameProperty(configInstance, "command.repair_ignores_liquids", "repair_raycast_ignores_liquids");
            }
        });
        Config.registerMigration("6", "7", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, "gameplay.tconstruct.slime_sapling_bone_mealable")) {
                MigrationUtils.renameProperty(configInstance, "gameplay.tconstruct.slime_sapling_bone_mealable", "can_bone_meal_slime_saplings");
            }
        });
        Config.registerMigration("7", "8", configInstance -> {
            if (MigrationUtils.hasCategoryByPath(configInstance, "command")) {
                MigrationUtils.renameCategory(configInstance, "command", "commands");
            }
        });
        if (CONFIG_INSTANCE != null) {
            return;
        }
        CONFIG_INSTANCE = new Configuration(new File(configDir, fileName), CONFIG_VERSION, false);
    }

    public static void refresh() {
        if (CONFIG_INSTANCE == null) {
            GTNHCustomizer.getLogger().error("Cannot load configuration!");
            GTNHCustomizer.getLogger().error("Configuration has not been initialized yet!");
            return;
        }
        if (!CONFIG_INSTANCE.getLoadedConfigVersion().equals(CONFIG_VERSION)) {
            GTNHCustomizer.getLogger().error("Cannot load configuration!");
            GTNHCustomizer.getLogger().error("In-memory configuration version of '{}' does not equal expected configuration version of '{}'!", new Object[]{CONFIG_INSTANCE.getLoadedConfigVersion(), CONFIG_VERSION});
            return;
        }
        new Gameplay().loadValues(CONFIG_INSTANCE);
        new Debugging().loadValues(CONFIG_INSTANCE);
        new Commands().loadValues(CONFIG_INSTANCE);
    }

    public static void load() {
        if (CONFIG_INSTANCE == null) {
            GTNHCustomizer.getLogger().error("Cannot load configuration!");
            GTNHCustomizer.getLogger().error("Configuration has not been initialized yet!");
            return;
        }
        CONFIG_INSTANCE.load();
        if (!CONFIG_INSTANCE.getLoadedConfigVersion().equals(CONFIG_VERSION)) {
            GTNHCustomizer.getLogger().warn("Your configuration is out of date!");
            GTNHCustomizer.getLogger().warn("We're running version '{}' but you have version '{}'", new Object[]{CONFIG_VERSION, CONFIG_INSTANCE.getLoadedConfigVersion()});
            GTNHCustomizer.getLogger().warn("Attempting to migrate!");
            try {
                Config.applyConfigMigrations(CONFIG_INSTANCE.getLoadedConfigVersion(), CONFIG_VERSION, CONFIG_INSTANCE);
            }
            catch (NoSuchElementException t) {
                GTNHCustomizer.getLogger().info("No migrations available from version '{}' to version '{}', assuming migration is not required!", new Object[]{CONFIG_INSTANCE.getLoadedConfigVersion(), CONFIG_VERSION});
            }
            catch (Throwable t) {
                GTNHCustomizer.getLogger().warn("Could not migrate configuration from version '{}' to version '{}'!", new Object[]{CONFIG_INSTANCE.getLoadedConfigVersion(), CONFIG_VERSION});
                GTNHCustomizer.getLogger().warn("Here's a stack trace for you to use if you want to file a bug report about migrations failing:");
                GTNHCustomizer.getLogger().warn((Object)t);
                GTNHCustomizer.getLogger().warn("Any customizations you've made are probably about to get nuked!");
                File backupLocation = new File(String.format("%s.bak", CONFIG_INSTANCE.getConfigFile().getAbsolutePath()));
                GTNHCustomizer.getLogger().warn("Copying your current configuration into '{}' as a backup...", new Object[]{backupLocation.getAbsolutePath()});
                try {
                    Files.copy(CONFIG_INSTANCE.getConfigFile().toPath(), backupLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable tt) {
                    GTNHCustomizer.getLogger().warn("Failed to generate a backup of your current configuration!");
                    GTNHCustomizer.getLogger().warn("Here's a stack trace for you to use if you want to diagnose what happened:");
                    GTNHCustomizer.getLogger().warn((Object)tt);
                    GTNHCustomizer.getLogger().warn("Please do NOT file a bug report about failing to create a backup, this is almost certainly NOT the mod developer's fault!");
                    GTNHCustomizer.getLogger().warn("Proceeding anyway, sorry!");
                }
                CONFIG_INSTANCE.getCategoryNames().stream().forEach(categoryName -> CONFIG_INSTANCE.removeCategory(CONFIG_INSTANCE.getCategory(categoryName)));
            }
        }
        new Gameplay().registerForgeConfigCategory(CONFIG_INSTANCE, true);
        new Debugging().registerForgeConfigCategory(CONFIG_INSTANCE, true);
        new Commands().registerForgeConfigCategory(CONFIG_INSTANCE, true);
        new Gameplay().loadValues(CONFIG_INSTANCE);
        new Debugging().loadValues(CONFIG_INSTANCE);
        new Commands().loadValues(CONFIG_INSTANCE);
    }

    public static boolean hasChanged() {
        return CONFIG_INSTANCE == null ? false : CONFIG_INSTANCE.hasChanged();
    }

    public static void save() {
        if (CONFIG_INSTANCE == null) {
            GTNHCustomizer.getLogger().error("Cannot save configuration!");
            GTNHCustomizer.getLogger().error("Configuration has not been initialized yet!");
            return;
        }
        CONFIG_INSTANCE.save();
    }

    public static void sync() {
        Config.load();
        Config.save();
    }

    private static void applyConfigMigrations(String fromVersion, String toVersion, Configuration configInstance) throws NoSuchElementException, NumberFormatException {
        LinkedList<ImmutableTuple<String, Consumer<Configuration>>> migrators = new LinkedList<ImmutableTuple<String, Consumer<Configuration>>>();
        HashSet<String> alreadyMigratedVersions = new HashSet<String>();
        String lastMigratedVersion = fromVersion;
        while (MIGRATIONS.containsKey(lastMigratedVersion) && !lastMigratedVersion.equals(toVersion)) {
            migrators.push(MIGRATIONS.get(lastMigratedVersion));
            migrators.sort((a, b) -> Integer.parseInt((String)a.getFirst(), 10) - Integer.parseInt((String)b.getFirst(), 10));
            alreadyMigratedVersions.add(lastMigratedVersion);
            lastMigratedVersion = (String)((ImmutableTuple)migrators.peekLast()).getFirst();
            if (!alreadyMigratedVersions.contains(lastMigratedVersion)) continue;
            throw new RuntimeException("Cyclic migration detected!");
        }
        if (!lastMigratedVersion.equals(toVersion)) {
            throw new NoSuchElementException(String.format("No available migration route from configuration version '%s' to configuration version '%s'!", fromVersion, toVersion));
        }
        Configuration currentVersion = MigrationUtils.cloneConfiguration(CONFIG_INSTANCE);
        for (ImmutableTuple immutableTuple : migrators) {
            ((Consumer)immutableTuple.getSecond()).accept(currentVersion);
        }
        CONFIG_INSTANCE = currentVersion;
        if (Config.hasChanged()) {
            Config.save();
        }
    }

    private static void registerMigration(String fromVersion, String toVersion, Consumer<Configuration> migrator) throws KeyAlreadyExistsException {
        if (MIGRATIONS.containsKey(fromVersion)) {
            throw new KeyAlreadyExistsException(String.format("Migration already exists from configuration '%s' version to configuration version '%s'", fromVersion, toVersion));
        }
        MIGRATIONS.put(fromVersion, new ImmutableTuple<String, Consumer<Configuration>>(toVersion, migrator));
    }

    static {
        MIGRATIONS = new HashMap<String, ImmutableTuple<String, Consumer<Configuration>>>();
        globallyImmunePlayers = new ArrayList<String>();
        preventEnderMobTeleport = true;
        repairCommandIgnoresLiquids = false;
        tconstructCanBoneMealSlimeSaplings = true;
        thaumcraftCanBoneMealGreatwoodSaplings = true;
        thaumcraftCanBoneMealSilverwoodSaplings = true;
        extinguishCommandMaxVolume = Integer.MAX_VALUE;
        verboseLoggingEnabled = false;
        CONFIG_ID = UUID.randomUUID();
    }
}

