/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.config;

import com.glektarssza.gtnh_customizer.utils.exceptions.KeyAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class MigrationUtils {
    public static Property cloneProperty(Property property) {
        if (property.isList()) {
            return new Property(property.getName(), property.getStringList(), property.getType(), property.getLanguageKey()).setRequiresMcRestart(property.requiresMcRestart()).setRequiresWorldRestart(property.requiresWorldRestart());
        }
        return new Property(property.getName(), property.getString(), property.getType(), property.getValidValues(), property.getLanguageKey()).setRequiresMcRestart(property.requiresMcRestart()).setRequiresWorldRestart(property.requiresWorldRestart());
    }

    public static Property cloneProperty(Configuration instance, String path) {
        return MigrationUtils.cloneProperty(instance, path, ".");
    }

    public static Property cloneProperty(Configuration instance, String path, CharSequence pathSeparators) {
        return MigrationUtils.cloneProperty(MigrationUtils.getPropertyByPath(instance, path, pathSeparators));
    }

    public static ConfigCategory cloneCategory(ConfigCategory category) {
        return MigrationUtils.cloneCategory(category, null);
    }

    public static ConfigCategory cloneCategory(ConfigCategory category, ConfigCategory parent) {
        ConfigCategory cloned = new ConfigCategory(category.getName(), null);
        cloned.getChildren().forEach(childCategory -> MigrationUtils.cloneCategory(childCategory, cloned));
        category.forEach((key, prop) -> cloned.put(key, MigrationUtils.cloneProperty(prop)));
        return cloned;
    }

    public static ConfigCategory cloneCategory(Configuration instance, String path) {
        return MigrationUtils.cloneCategory(instance, path, ".");
    }

    public static ConfigCategory cloneCategory(Configuration instance, String path, ConfigCategory parent) {
        return MigrationUtils.cloneCategory(instance, path, parent, (CharSequence)".");
    }

    public static ConfigCategory cloneCategory(Configuration instance, String path, String parentPath) {
        return MigrationUtils.cloneCategory(instance, path, parentPath, (CharSequence)".");
    }

    public static ConfigCategory cloneCategory(Configuration instance, String path, ConfigCategory parent, CharSequence pathSeparators) {
        return MigrationUtils.cloneCategory(MigrationUtils.getCategoryByPath(instance, path, pathSeparators), parent);
    }

    public static ConfigCategory cloneCategory(Configuration instance, String path, String parentPath, CharSequence pathSeparators) {
        return MigrationUtils.cloneCategory(MigrationUtils.getCategoryByPath(instance, path, pathSeparators), MigrationUtils.getCategoryByPath(instance, path, pathSeparators));
    }

    public static void copyProperty(Configuration instance, Configuration newInstance, String path) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyProperty(instance, newInstance, path, ".", false);
    }

    public static void copyProperty(Configuration instance, Configuration newInstance, String path, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyProperty(instance, newInstance, path, ".");
    }

    public static void copyProperty(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyProperty(instance, newInstance, path, pathSeparators, false);
    }

    public static void copyProperty(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        if (!MigrationUtils.hasPropertyByPath(instance, path, pathSeparators)) {
            throw new NoSuchElementException(String.format("Cannot copy configuration property '%s' to the given configuration instance (no property exists to copy)", path));
        }
        boolean hasPropertyAlready = MigrationUtils.hasPropertyByPath(newInstance, path, pathSeparators);
        if (hasPropertyAlready && !overwrite) {
            throw new KeyAlreadyExistsException(String.format("Cannot copy configuration property '%s' to the given configuration instance (a property already exists there)", path));
        }
        ConfigCategory oldCategory = MigrationUtils.getPropertyParentCategoryByPath(instance, path, pathSeparators);
        Property oldProperty = MigrationUtils.getPropertyByPath(instance, path, pathSeparators);
        if (hasPropertyAlready) {
            MigrationUtils.getPropertyParentCategoryByPath(newInstance, path, pathSeparators).remove((Object)oldProperty.getName());
        }
        if (!MigrationUtils.hasCategoryByPath(newInstance, oldCategory.getQualifiedName(), pathSeparators)) {
            throw new NoSuchElementException(String.format("Cannot copy configuration property '%s' to the given configuration instance (no category exists to copy it onto)", path));
        }
        newInstance.getCategory(oldCategory.getQualifiedName()).put(oldProperty.getName(), MigrationUtils.cloneProperty(oldProperty));
    }

    public static boolean tryCopyProperty(Configuration instance, Configuration newInstance, String path) {
        return MigrationUtils.tryCopyProperty(instance, newInstance, path, ".");
    }

    public static boolean tryCopyProperty(Configuration instance, Configuration newInstance, String path, boolean overwrite) {
        return MigrationUtils.tryCopyProperty(instance, newInstance, path, ".", overwrite);
    }

    public static boolean tryCopyProperty(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) {
        try {
            MigrationUtils.copyProperty(instance, newInstance, path, pathSeparators, false);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean tryCopyProperty(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) {
        return MigrationUtils.tryCopyProperty(instance, newInstance, path, pathSeparators, overwrite);
    }

    public static void copyCategory(Configuration instance, Configuration newInstance, String path) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyCategory(instance, newInstance, path, ".");
    }

    public static void copyCategory(Configuration instance, Configuration newInstance, String path, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyCategory(instance, newInstance, path, ".", overwrite);
    }

    public static void copyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyCategory(instance, newInstance, path, pathSeparators, false);
    }

    public static void copyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        ConfigCategory oldCategory = MigrationUtils.getCategoryByPath(instance, path, pathSeparators);
        if (newInstance.hasCategory(oldCategory.getQualifiedName()) && !overwrite) {
            throw new KeyAlreadyExistsException(String.format("Cannot copy configuration category '%s' to the given configuration instance (a category already exists there)", path));
        }
        if (newInstance.hasCategory(oldCategory.getQualifiedName())) {
            newInstance.removeCategory(newInstance.getCategory(oldCategory.getQualifiedName()));
        }
        ConfigCategory newCategory = newInstance.getCategory(oldCategory.getQualifiedName());
        newCategory.setComment(oldCategory.getComment());
        newCategory.setLanguageKey(oldCategory.getLanguagekey());
        newCategory.setRequiresMcRestart(oldCategory.requiresMcRestart());
        newCategory.setRequiresWorldRestart(oldCategory.requiresWorldRestart());
        newCategory.setConfigEntryClass(oldCategory.getConfigEntryClass());
        newCategory.setShowInGui(oldCategory.showInGui());
    }

    public static boolean tryCopyCategory(Configuration instance, Configuration newInstance, String path) {
        return MigrationUtils.tryCopyCategory(instance, newInstance, path, ".", false);
    }

    public static boolean tryCopyCategory(Configuration instance, Configuration newInstance, String path, boolean overwrite) {
        return MigrationUtils.tryCopyCategory(instance, newInstance, path, ".", overwrite);
    }

    public static boolean tryCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) {
        try {
            MigrationUtils.copyCategory(instance, newInstance, path, ".", false);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean tryCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) {
        try {
            MigrationUtils.copyCategory(instance, newInstance, path, ".", overwrite);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void deepCopyCategory(Configuration instance, Configuration newInstance, String path) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.deepCopyCategory(instance, newInstance, path, ".", false);
    }

    public static void deepCopyCategory(Configuration instance, Configuration newInstance, String path, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.deepCopyCategory(instance, newInstance, path, ".", overwrite);
    }

    public static void deepCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.deepCopyCategory(instance, newInstance, path, pathSeparators, false);
    }

    public static void deepCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.copyCategory(instance, newInstance, path, pathSeparators, overwrite);
        MigrationUtils.getCategoryByPath(instance, path, pathSeparators).forEach((propertyName, property) -> MigrationUtils.copyProperty(instance, newInstance, String.format("%s%s%s", path, ".", propertyName), overwrite));
        MigrationUtils.getCategoryByPath(instance, path, pathSeparators).getChildren().forEach(category -> MigrationUtils.copyCategory(instance, newInstance, category.getQualifiedName(), pathSeparators, overwrite));
        MigrationUtils.getCategoryByPath(newInstance, path, pathSeparators).setPropertyOrder(new ArrayList(MigrationUtils.getCategoryByPath(instance, path, pathSeparators).getPropertyOrder()));
    }

    public static boolean tryDeepCopyCategory(Configuration instance, Configuration newInstance, String path) {
        return MigrationUtils.tryDeepCopyCategory(instance, newInstance, path, ".", false);
    }

    public static boolean tryDeepCopyCategory(Configuration instance, Configuration newInstance, String path, boolean overwrite) {
        return MigrationUtils.tryDeepCopyCategory(instance, newInstance, path, ".", overwrite);
    }

    public static boolean tryDeepCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators) {
        try {
            MigrationUtils.deepCopyCategory(instance, newInstance, path, ".", false);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean tryDeepCopyCategory(Configuration instance, Configuration newInstance, String path, CharSequence pathSeparators, boolean overwrite) {
        try {
            MigrationUtils.deepCopyCategory(instance, newInstance, path, ".", overwrite);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static Configuration cloneConfiguration(Configuration instance) {
        Configuration cloned = new Configuration(instance.getConfigFile(), instance.getDefinedConfigVersion(), false);
        instance.getCategoryNames().forEach(category -> MigrationUtils.deepCopyCategory(instance, cloned, category, true));
        return cloned;
    }

    @Nullable
    public static Configuration tryCloneConfiguration(Configuration instance) {
        try {
            return MigrationUtils.cloneConfiguration(instance);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void copyConfiguration(Configuration instance, Configuration newInstance) throws NoSuchElementException, KeyAlreadyExistsException {
        instance.getCategoryNames().parallelStream().forEach(categoryName -> MigrationUtils.copyCategory(instance, newInstance, categoryName));
    }

    public static boolean tryCopyConfiguration(Configuration instance, Configuration newInstance) {
        try {
            MigrationUtils.copyConfiguration(instance, newInstance);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void renameProperty(Configuration instance, String path, String newName) throws NoSuchElementException, KeyAlreadyExistsException {
        MigrationUtils.renameProperty(instance, path, newName, ".");
    }

    public static void renameProperty(Configuration instance, String path, String newName, CharSequence pathSeparators) throws NoSuchElementException, KeyAlreadyExistsException {
        ConfigCategory category = MigrationUtils.getPropertyParentCategoryByPath(instance, path, pathSeparators);
        Property property = MigrationUtils.getPropertyByPath(instance, path, pathSeparators);
        if (category.containsKey(newName)) {
            throw new KeyAlreadyExistsException(String.format("Cannot rename configuration property '%s' from '%s' to '%s' (a property already exists there)", path, property.getName(), newName));
        }
        category.remove((Object)property.getName());
        property.setName(newName);
        category.put(newName, property);
    }

    public static boolean tryRenameProperty(Configuration instance, String path, String newName) {
        return MigrationUtils.tryRenameProperty(instance, path, newName, ".");
    }

    public static boolean tryRenameProperty(Configuration instance, String path, String newName, CharSequence pathSeparators) {
        try {
            MigrationUtils.renameProperty(instance, path, newName);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void moveProperty(Configuration instance, String path, String newCategoryPath) throws NoSuchElementException {
        MigrationUtils.moveProperty(instance, path, newCategoryPath, ".");
    }

    public static void moveProperty(Configuration instance, String path, String newCategoryPath, CharSequence pathSeparators) throws NoSuchElementException {
        Property property = MigrationUtils.getPropertyByPath(instance, path, pathSeparators);
        ConfigCategory oldCategory = MigrationUtils.getPropertyParentCategoryByPath(instance, path, pathSeparators);
        ConfigCategory newCategory = MigrationUtils.getCategoryByPath(instance, newCategoryPath, pathSeparators);
        if (newCategory.containsKey(property.getName())) {
            throw new KeyAlreadyExistsException(String.format("Cannot move configuration property '%s' from category '%s' to '%s' (a property already exists there of the same name)", property.getName(), oldCategory.getQualifiedName(), newCategory.getQualifiedName()));
        }
        oldCategory.remove((Object)property.getName());
        newCategory.put(property.getName(), property);
    }

    public static boolean tryMoveProperty(Configuration instance, String path, String newCategoryPath) {
        return MigrationUtils.tryMoveProperty(instance, path, newCategoryPath, ".");
    }

    public static boolean tryMoveProperty(Configuration instance, String path, String newCategoryPath, CharSequence pathSeparators) {
        try {
            MigrationUtils.moveProperty(instance, path, newCategoryPath, pathSeparators);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void moveAndRenameProperty(Configuration instance, String path, String newPath) throws NoSuchElementException {
        MigrationUtils.moveAndRenameProperty(instance, path, newPath, ".");
    }

    public static void moveAndRenameProperty(Configuration instance, String path, String newPath, CharSequence pathSeparators) throws NoSuchElementException {
        Property property = MigrationUtils.getPropertyByPath(instance, path, pathSeparators);
        ConfigCategory oldCategory = MigrationUtils.getPropertyParentCategoryByPath(instance, path, pathSeparators);
        ConfigCategory newCategory = MigrationUtils.getPropertyParentCategoryByPath(instance, newPath, pathSeparators);
        String[] newNameComps = MigrationUtils.splitPath(newPath, pathSeparators);
        String newName = newNameComps[newNameComps.length - 1];
        if (newCategory.containsKey(property.getName())) {
            throw new KeyAlreadyExistsException(String.format("Cannot move and rename configuration property '%s' to '%s' (a property already exists there)", path, newPath));
        }
        oldCategory.remove((Object)property.getName());
        property.setName(newName);
        newCategory.put(newName, property);
    }

    public static boolean tryMoveAndRenameProperty(Configuration instance, String path, String newPath) {
        return MigrationUtils.tryMoveAndRenameProperty(instance, path, newPath, ".");
    }

    public static boolean tryMoveAndRenameProperty(Configuration instance, String path, String newPath, CharSequence pathSeparators) {
        try {
            MigrationUtils.moveAndRenameProperty(instance, path, newPath, pathSeparators);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void renameCategory(Configuration instance, String path, String newName) throws NoSuchElementException {
        CharSequence[] pathComps = MigrationUtils.splitPath(path, ".");
        pathComps[pathComps.length - 1] = newName;
        MigrationUtils.moveCategory(instance, path, String.join((CharSequence)".", pathComps));
    }

    public static boolean tryRenameCategory(Configuration instance, String path, String newName) {
        try {
            MigrationUtils.renameCategory(instance, path, newName);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void moveCategory(Configuration instance, String path, String newPath) throws NoSuchElementException {
        ConfigCategory category = MigrationUtils.getCategoryByPath(instance, path);
        ConfigCategory newCategory = instance.getCategory(newPath);
        newCategory.setComment(category.getComment());
        newCategory.setLanguageKey(category.getLanguagekey());
        newCategory.setPropertyOrder(Arrays.asList(category.getPropertyOrder().toArray(new String[0])));
        newCategory.setRequiresMcRestart(category.requiresMcRestart());
        newCategory.setRequiresWorldRestart(category.requiresWorldRestart());
        newCategory.setShowInGui(category.showInGui());
        newCategory.setConfigEntryClass(category.getConfigEntryClass());
        category.entrySet().forEach(entry -> newCategory.put((String)entry.getKey(), (Property)entry.getValue()));
        category.getChildren().forEach(child -> MigrationUtils.moveCategory(instance, ConfigCategory.getQualifiedName((String)child.getName(), (ConfigCategory)category), ConfigCategory.getQualifiedName((String)child.getName(), (ConfigCategory)newCategory)));
        instance.removeCategory(category);
    }

    public static boolean tryMoveCategory(Configuration instance, String path, String newPath) {
        try {
            MigrationUtils.moveCategory(instance, path, newPath);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean hasCategoryByPath(Configuration instance, String path) {
        return MigrationUtils.hasCategoryByPath(instance, path, ".");
    }

    public static boolean hasCategoryByPath(Configuration instance, String path, CharSequence pathSeparators) {
        return MigrationUtils.tryGetCategoryByPath(instance, path, ".") != null;
    }

    public static boolean hasPropertyByPath(Configuration instance, String path) {
        return MigrationUtils.hasPropertyByPath(instance, path, ".");
    }

    public static boolean hasPropertyByPath(Configuration instance, String path, CharSequence pathSeparators) {
        return MigrationUtils.tryGetPropertyByPath(instance, path, ".") != null;
    }

    public static ConfigCategory getCategoryByPath(Configuration instance, String path) throws NoSuchElementException {
        return MigrationUtils.getCategoryByPath(instance, path, ".");
    }

    public static ConfigCategory getCategoryByPath(Configuration instance, String path, CharSequence pathSeparators) throws NoSuchElementException {
        String[] pathComps = MigrationUtils.splitPath(path, pathSeparators);
        if (pathComps.length > 0) {
            if (!instance.hasCategory(pathComps[0])) {
                throw new NoSuchElementException(String.format("No such configuration category with path '%s'", path));
            }
            ConfigCategory category = instance.getCategory(pathComps[0]);
            for (int i = 1; i < pathComps.length; ++i) {
                String categoryComp = pathComps[i];
                Optional<ConfigCategory> newCategory = category.getChildren().parallelStream().filter(item -> item.getName().equals(categoryComp)).findFirst();
                if (!newCategory.isPresent()) {
                    return null;
                }
                category = newCategory.get();
            }
            return category;
        }
        throw new NoSuchElementException(String.format("No such configuration category with path '%s'", path));
    }

    @Nullable
    public static ConfigCategory tryGetCategoryByPath(Configuration instance, String path) {
        return MigrationUtils.tryGetCategoryByPath(instance, path, ".");
    }

    @Nullable
    public static ConfigCategory tryGetCategoryByPath(Configuration instance, String path, CharSequence pathSeparators) {
        try {
            return MigrationUtils.getCategoryByPath(instance, path, pathSeparators);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Property getPropertyByPath(Configuration instance, String path) throws NoSuchElementException {
        return MigrationUtils.getPropertyByPath(instance, path, ".");
    }

    public static Property getPropertyByPath(Configuration instance, String path, CharSequence pathSeparators) throws NoSuchElementException {
        String[] pathComps = MigrationUtils.splitPath(path, pathSeparators);
        if (pathComps.length > 1) {
            ConfigCategory category = MigrationUtils.getCategoryByPath(instance, String.join((CharSequence)".", Arrays.copyOfRange(pathComps, 0, pathComps.length - 1)));
            if (!category.containsKey(pathComps[pathComps.length - 1])) {
                throw new NoSuchElementException(String.format("No such configuration property with path '%s'", path));
            }
            return category.get(pathComps[pathComps.length - 1]);
        }
        throw new NoSuchElementException(String.format("No such configuration property with path '%s'", path));
    }

    @Nullable
    public static Property tryGetPropertyByPath(Configuration instance, String path) {
        return MigrationUtils.tryGetPropertyByPath(instance, path, ".");
    }

    @Nullable
    public static Property tryGetPropertyByPath(Configuration instance, String path, CharSequence pathSeparators) {
        try {
            return MigrationUtils.getPropertyByPath(instance, path, pathSeparators);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ConfigCategory getPropertyParentCategoryByPath(Configuration instance, String path) throws NoSuchElementException {
        return MigrationUtils.getPropertyParentCategoryByPath(instance, path, ".");
    }

    public static ConfigCategory getPropertyParentCategoryByPath(Configuration instance, String path, CharSequence pathSeparators) throws NoSuchElementException {
        if (!MigrationUtils.hasPropertyByPath(instance, path, pathSeparators)) {
            throw new NoSuchElementException(String.format("No such configuration property with path '%s'", path));
        }
        String[] pathComps = MigrationUtils.splitPath(path, pathSeparators);
        return MigrationUtils.getCategoryByPath(instance, String.join((CharSequence)".", Arrays.copyOfRange(pathComps, 0, pathComps.length - 1)));
    }

    @Nullable
    public static ConfigCategory tryGetPropertyParentCategoryByPath(Configuration instance, String path) {
        return MigrationUtils.tryGetPropertyParentCategoryByPath(instance, path, ".");
    }

    @Nullable
    public static ConfigCategory tryGetPropertyParentCategoryByPath(Configuration instance, String path, CharSequence pathSeparators) {
        try {
            return MigrationUtils.getPropertyParentCategoryByPath(instance, path, pathSeparators);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String[] splitPath(String path, CharSequence pathSeparators) {
        StringBuilder sb = new StringBuilder();
        List seps = pathSeparators.chars().mapToObj(i -> String.valueOf(Character.toChars(i))).collect(Collectors.toList());
        sb.append('[');
        while (!seps.isEmpty()) {
            String sep = (String)seps.remove(0);
            if (sep.equals("-") && !seps.isEmpty()) {
                seps.add(sep);
                sep = (String)seps.get(0);
            }
            sb.append(sep);
            if (!sep.equals("\\")) continue;
            sb.append(sep);
        }
        sb.append(']');
        return path.split(sb.toString());
    }
}

