/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import com.glektarssza.gtnh_customizer.utils.ImmutableTuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;

public class ListDimensionsCommand
extends CommandBase {
    public String func_71517_b() {
        return "list-dimensions";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public String func_71518_a(ICommandSender sender) {
        return "gtnh_customizer.commands.list_dimensions.usage";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        Integer limit = null;
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            try {
                limit = Integer.parseInt(args[0], 10);
                continue;
            }
            catch (Throwable t) {
                filters.add(args[i]);
            }
        }
        if (limit == null) {
            limit = 512;
        }
        if (limit < 0) {
            throw new CommandException("gtnh_customizer.commands.list_dimensions.error.invalid_limit", new Object[]{limit});
        }
        Stream<ImmutableTuple> dimensionStream = CommandUtils.getAllDimensionIDsIterable().parallelStream().map(id -> new ImmutableTuple<Integer, String>((Integer)id, DimensionManager.getProvider((int)id).func_80007_l()));
        if (filters.size() > 0) {
            dimensionStream = dimensionStream.filter(tuple -> filters.stream().anyMatch(filter -> ((String)tuple.getSecond()).toLowerCase().contains(filter.toLowerCase())));
        }
        List dimensions = dimensionStream.limit(limit.intValue()).collect(Collectors.toList());
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("gtnh_customizer.commands.list_dimensions.info.header", new Object[0]));
        for (int i = 0; i < dimensions.size(); ++i) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("gtnh_customizer.commands.list_dimensions.info.entry", new Object[]{((ImmutableTuple)dimensions.get(i)).getFirst(), ((ImmutableTuple)dimensions.get(i)).getSecond()}));
        }
    }
}

