/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import cpw.mods.fml.common.Loader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.math.BlockDimPos;

public class TeleportCrossDimensionCommand
extends CommandBase {
    public String func_71517_b() {
        return "teleport-cross-dimension";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("tpxd", "tpd");
    }

    public String func_71518_a(ICommandSender sender) {
        return "gtnh_customizer.commands.teleport_cross_dimension.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        if (index == 0) {
            return !CommandUtils.isCoordinateArgument(args, index);
        }
        if (index == 1 && this.func_82358_a(args, 0)) {
            return !CommandUtils.isCoordinateArgument(args, index);
        }
        return false;
    }

    public boolean isCoordinateIndex(String[] args, int index) {
        if (this.func_82358_a(args, 0) && this.func_82358_a(args, 1)) {
            return false;
        }
        if (this.func_82358_a(args, 0)) {
            return index == 1 || index == 2 || index == 3;
        }
        return index == 0 || index == 1 || index == 2;
    }

    public boolean isDimensionIndex(String[] args, int index) {
        if (this.func_82358_a(args, 0) && this.func_82358_a(args, 1)) {
            return false;
        }
        if (this.func_82358_a(args, 0)) {
            return index == 4;
        }
        return index == 3;
    }

    public boolean isYawIndex(String[] args, int index) {
        if (this.func_82358_a(args, 0) && this.func_82358_a(args, 1)) {
            return false;
        }
        if (this.func_82358_a(args, 0)) {
            return index == 5;
        }
        return index == 4;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        List<String> result = null;
        int index = args.length - 1;
        switch (index) {
            case 0: {
                try {
                    victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                if (victim != null) {
                    result.add(0, "~");
                }
                return result;
            }
            case 1: {
                if (this.func_82358_a(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                    result.add(0, "~");
                    return result;
                }
                try {
                    victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                if (this.isCoordinateIndex(args, 0)) {
                    return Collections.singletonList("~");
                }
                return null;
            }
            case 2: {
                if (this.func_82358_a(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    if (this.func_82358_a(args, 1)) {
                        return Collections.singletonList("~");
                    }
                    if (this.isCoordinateIndex(args, 1)) {
                        return Collections.singletonList("~");
                    }
                    return null;
                }
                try {
                    victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                if (this.isCoordinateIndex(args, 1)) {
                    return Collections.singletonList("~");
                }
                return null;
            }
            case 3: {
                if (this.func_82358_a(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    if (this.isCoordinateIndex(args, index)) {
                        return Collections.singletonList("~");
                    }
                    return null;
                }
                try {
                    victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                result = CommandUtils.getTruncatedDimensionIDsIterable(512).parallelStream().map(id -> String.format("%d", id)).collect(Collectors.toList());
                result.add(0, "~");
                return result;
            }
            case 4: {
                if (this.func_82358_a(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    result = CommandUtils.getTruncatedDimensionIDsIterable(512).parallelStream().map(id -> String.format("%d", id)).collect(Collectors.toList());
                    result.add(0, "~");
                    return result;
                }
                try {
                    victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                return Collections.singletonList("~");
            }
            case 5: {
                if (this.func_82358_a(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    return Collections.singletonList("~");
                }
                return null;
            }
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        EntityPlayerMP target = null;
        if (args.length > 1 && this.func_82358_a(args, 0) && this.func_82358_a(args, 1)) {
            victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
            target = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[1]);
        } else if (args.length > 1 && this.func_82358_a(args, 0) && !this.func_82358_a(args, 1)) {
            victim = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
        } else if (args.length > 0 && this.func_82358_a(args, 0)) {
            victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
            target = TeleportCrossDimensionCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
        } else if (args.length > 0) {
            victim = TeleportCrossDimensionCommand.func_71521_c((ICommandSender)sender);
        } else {
            throw new WrongUsageException("gtnh_customizer.commands.teleport_cross_dimension.error.not_enough_arguments", new Object[0]);
        }
        if (victim != null && target != null) {
            Float yawOverride = null;
            if (args.length > 2) {
                try {
                    yawOverride = Float.valueOf(CommandUtils.parseBlockRelativeFloatArgument(sender, args[2], victim.field_70177_z, false));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.sendVictimToTarget(sender, victim, target, yawOverride);
            sender.func_145747_a(new ChatComponentTranslation("gtnh_customizer.commands.teleport_cross_dimension.warning.sent_self_to_self", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150217_b(Boolean.valueOf(true))));
            return;
        }
        if (victim != null) {
            int offset;
            Double targetBlockPosX = null;
            Double targetBlockPosY = null;
            Double targetBlockPosZ = null;
            int targetDimension = victim.field_71093_bK;
            Float yawOverride = null;
            int n = offset = this.func_82358_a(args, 0) ? 1 : 0;
            if (args.length > offset + 3) {
                if (args[offset + 3].startsWith("~")) {
                    if (args[offset + 3].length() > 1) {
                        throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.unknown_dimension", new Object[]{String.format("%d", args[offset + 3])});
                    }
                    targetDimension = victim.field_71093_bK;
                } else {
                    try {
                        targetDimension = Integer.parseInt(args[offset + 3], 10);
                    }
                    catch (Throwable t) {
                        throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.unknown_dimension", new Object[]{String.format("%d", args[offset + 3])});
                    }
                }
            }
            try {
                targetBlockPosX = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 0], victim.field_70165_t, !args[offset + 0].contains("."));
                targetBlockPosY = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 1], victim.field_70163_u, !args[offset + 1].contains("."));
                targetBlockPosZ = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 2], victim.field_70161_v, !args[offset + 2].contains("."));
            }
            catch (Throwable t) {
                throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.bad_destination", new Object[]{String.format("%.2f", args[offset + 0]), String.format("%.2f", args[offset + 1]), String.format("%.2f", args[offset + 2])});
            }
            if (args.length > offset + 4) {
                try {
                    yawOverride = Float.valueOf(CommandUtils.parseBlockRelativeFloatArgument(sender, args[offset + 4], victim.field_70177_z, false));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.sendVictimToLocation(sender, victim, targetBlockPosX, targetBlockPosY, targetBlockPosZ, targetDimension, yawOverride, Float.valueOf(victim.field_70125_A));
            return;
        }
        throw new WrongUsageException("gtnh_customizer.commands.teleport_cross_dimension.error.wrong_usage", new Object[0]);
    }

    private void sendVictimToTarget(ICommandSender sender, EntityPlayerMP victim, EntityPlayerMP target, Float yawOverride) {
        this.sendVictimToLocation(sender, victim, target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_71093_bK, yawOverride, Float.valueOf(target.field_70125_A));
    }

    private void sendVictimToLocation(ICommandSender sender, EntityPlayerMP victim, double xPos, double yPos, double zPos, int dimension, Float yawOverride, Float pitchOverride) {
        float yaw = victim.field_70177_z;
        float pitch = victim.field_70125_A;
        if (yawOverride != null) {
            yaw = yawOverride.floatValue();
        }
        if (pitchOverride != null) {
            pitch = pitchOverride.floatValue();
        }
        this.updatePlayerLastLocation(victim);
        if (victim.field_71093_bK != dimension) {
            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(victim, dimension, (Teleporter)new CrossDimensionCommandTeleporter(MinecraftServer.func_71276_C().func_71218_a(dimension), xPos, yPos, zPos, yaw, pitch));
        } else {
            victim.field_71135_a.func_147364_a(xPos, yPos, zPos, yaw, pitch);
        }
        TeleportCrossDimensionCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.teleport_cross_dimension.info.teleported", (Object[])new Object[]{victim.getDisplayName(), String.format("%.2f", xPos), String.format("%.2f", yPos), String.format("%.2f", zPos), String.format("%.2f", Float.valueOf(yaw)), String.format("%.2f", Float.valueOf(pitch)), DimensionManager.getProvider((int)dimension).func_80007_l(), String.format("%d", dimension)});
    }

    private void updatePlayerLastLocation(EntityPlayerMP victim) {
        if (Loader.isModLoaded((String)"serverutilities")) {
            ServerUtilitiesPlayerData.get((ICommandSender)victim).setLastTeleport(TeleportType.VANILLA_TP, new BlockDimPos((EntityPlayer)victim));
        }
    }

    private static class CrossDimensionCommandTeleporter
    extends Teleporter {
        private double xPos;
        private double yPos;
        private double zPos;
        private float yaw;
        private float pitch;

        public CrossDimensionCommandTeleporter(WorldServer worldIn, double xPos, double yPos, double zPos, float yaw, float pitch) {
            super(worldIn);
            this.xPos = xPos;
            this.yPos = yPos;
            this.zPos = zPos;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public void func_77185_a(Entity entity, double xPos, double yPos, double zPos, float yaw) {
            entity.func_70012_b(this.xPos, this.yPos, this.zPos, this.yaw, this.pitch);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
        }
    }
}

