/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityMob.class})
public class EntityMobMixin {
    @Inject(method={"findPlayerToAttack"}, at={@At(value="RETURN")}, cancellable=true)
    public void findPlayerToAttack(CallbackInfoReturnable<Entity> cir) {
        Entity target = (Entity)cir.getReturnValue();
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="RETURN")}, cancellable=true)
    public void attackEntityFrom$disableIfConfigured(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityMob self = (EntityMob)this;
        Entity targetEntity = self.func_70777_m();
        if (targetEntity == null) {
            return;
        }
        if (!(targetEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)targetEntity;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            self.func_70784_b(null);
        }
    }
}

