/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.late.xaeros.client;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.config.Config;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.entity.EntityClientPlayerMP;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;

@Mixin(value={WaypointsManager.class})
public class WaypointsManagerMixins {
    private static final Pattern COMMAND_PARAMETER_PATTERN = Pattern.compile("\\{([a-zA-Z]+)\\}");

    @Redirect(method={"teleportToWaypoint(Lxaero/common/minimap/waypoints/Waypoint;Lxaero/common/minimap/waypoints/WaypointWorld;Lnet/minecraft/client/gui/GuiScreen;Z)V"}, at=@At(value="INVOKE", target="net.minecraft.client.entity.EntityClientPlayerMP.sendChatMessage(Ljava/lang/String;)V"))
    private void teleportToWaypoint$overrideSendTeleportCommand(EntityClientPlayerMP player, String originalTeleportCommand, @Local(name={"x"}) int x, @Local(name={"z"}) int z, @Local(name={"selected"}) Waypoint selected, @Local(name={"displayedWorld"}) WaypointWorld displayedWorld, @Local(name={"tpCommandPrefix"}) String tpCommandPrefix) {
        if (!COMMAND_PARAMETER_PATTERN.matcher(tpCommandPrefix).find()) {
            player.func_71165_d(originalTeleportCommand);
            return;
        }
        String dimensionId = displayedWorld.getContainer().getSubId();
        if (dimensionId.startsWith("dim%")) {
            try {
                int dimId = Integer.parseInt(dimensionId.substring(4));
                dimensionId = String.format("%d", dimId);
            }
            catch (NumberFormatException t) {
                GTNHCustomizer.getLogger().warn("Non-integer dimension ID '{}', teleport command is probably going to fail!", new Object[]{dimensionId.substring(4)});
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", player.getDisplayName());
        params.put("n", player.getDisplayName());
        params.put("dimension", dimensionId);
        params.put("dim", dimensionId);
        params.put("d", dimensionId);
        params.put("x", String.format("%d", selected.getX()));
        params.put("y", String.format("%d", selected.getY()));
        params.put("z", String.format("%d", selected.getZ()));
        params.put("rotation", selected.isRotation() ? String.format("%d", selected.getYaw()) : "");
        params.put("rot", selected.isRotation() ? String.format("%d", selected.getYaw()) : "");
        params.put("yaw", selected.isRotation() ? String.format("%d", selected.getYaw()) : "");
        params.put("r", selected.isRotation() ? String.format("%d", selected.getYaw()) : "");
        Matcher matcher = COMMAND_PARAMETER_PATTERN.matcher(tpCommandPrefix);
        StringBuffer teleportCommandBuffer = new StringBuffer();
        while (matcher.find()) {
            String paramName;
            if (matcher.groupCount() < 1 || !params.containsKey(paramName = matcher.group(1))) continue;
            matcher.appendReplacement(teleportCommandBuffer, (String)params.get(paramName));
        }
        matcher.appendTail(teleportCommandBuffer);
        if (Config.getVerboseLoggingEnabled()) {
            GTNHCustomizer.getLogger().debug("Final Xaero's teleport command: {}", new Object[]{teleportCommandBuffer.toString()});
        }
        player.func_71165_d(teleportCommandBuffer.toString());
    }
}

