/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.api.immunity;

import com.glektarssza.gtnh_customizer.api.immunity.IImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.ImmunityType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public interface IKnockbackImmunity
extends IImmunity<NBTTagCompound> {
    @Override
    default public ImmunityType getImmunityType() {
        return ImmunityType.Hurt;
    }

    @Override
    default public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagString immunityType = ImmunityType.toNBTString(this.getImmunityType());
        String entityType = null;
        if (immunityType == null) {
            return nbt;
        }
        if (this.hasEntityType()) {
            entityType = this.getEntityType();
        }
        nbt.setTag("immunityType", (NBTBase)immunityType);
        if (entityType != null) {
            nbt.setString("entityType", entityType);
        }
        return nbt;
    }

    @Override
    default public void deserializeNBT(NBTTagCompound nbt) {
        if (!nbt.hasKey("immunityType", 8)) {
            return;
        }
        ImmunityType type = ImmunityType.fromNBTString((NBTTagString)nbt.getTag("immunityType"));
        if (type != ImmunityType.Knockback) {
            return;
        }
        if (nbt.hasKey("entityType", 8)) {
            this.setEntityType(nbt.getString("entityType"));
        } else {
            this.setEntityType(null);
        }
    }
}

