/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import cpw.mods.fml.common.Loader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.math.BlockDimPos;

public class TeleportCrossDimensionCommand
extends CommandBase {
    public String getCommandName() {
        return "teleport-cross-dimension";
    }

    public List<String> getCommandAliases() {
        return Arrays.asList("tpxd", "tpd");
    }

    public String getCommandUsage(ICommandSender sender) {
        return "gtnh_customizer.commands.teleport_cross_dimension.usage";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public boolean isUsernameIndex(String[] args, int index) {
        if (index == 0) {
            return !CommandUtils.isCoordinateArgument(args, index);
        }
        if (index == 1 && this.isUsernameIndex(args, 0)) {
            return !CommandUtils.isCoordinateArgument(args, index);
        }
        return false;
    }

    public boolean isCoordinateIndex(String[] args, int index) {
        if (this.isUsernameIndex(args, 0) && this.isUsernameIndex(args, 1)) {
            return false;
        }
        if (this.isUsernameIndex(args, 0)) {
            return index == 1 || index == 2 || index == 3;
        }
        return index == 0 || index == 1 || index == 2;
    }

    public boolean isDimensionIndex(String[] args, int index) {
        if (this.isUsernameIndex(args, 0) && this.isUsernameIndex(args, 1)) {
            return false;
        }
        if (this.isUsernameIndex(args, 0)) {
            return index == 4;
        }
        return index == 3;
    }

    public boolean isYawIndex(String[] args, int index) {
        if (this.isUsernameIndex(args, 0) && this.isUsernameIndex(args, 1)) {
            return false;
        }
        if (this.isUsernameIndex(args, 0)) {
            return index == 5;
        }
        return index == 4;
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        List<String> result = null;
        int index = args.length - 1;
        switch (index) {
            case 0: {
                try {
                    victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                if (victim != null) {
                    result.add(0, "~");
                }
                return result;
            }
            case 1: {
                if (this.isUsernameIndex(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                    result.add(0, "~");
                    return result;
                }
                try {
                    victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                if (this.isCoordinateIndex(args, 0)) {
                    return Collections.singletonList("~");
                }
                return null;
            }
            case 2: {
                if (this.isUsernameIndex(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    if (this.isUsernameIndex(args, 1)) {
                        return Collections.singletonList("~");
                    }
                    if (this.isCoordinateIndex(args, 1)) {
                        return Collections.singletonList("~");
                    }
                    return null;
                }
                try {
                    victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                if (this.isCoordinateIndex(args, 1)) {
                    return Collections.singletonList("~");
                }
                return null;
            }
            case 3: {
                if (this.isUsernameIndex(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    if (this.isCoordinateIndex(args, index)) {
                        return Collections.singletonList("~");
                    }
                    return null;
                }
                try {
                    victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                result = CommandUtils.getTruncatedDimensionIDsIterable(512).parallelStream().map(id -> String.format("%d", id)).collect(Collectors.toList());
                result.add(0, "~");
                return result;
            }
            case 4: {
                if (this.isUsernameIndex(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    result = CommandUtils.getTruncatedDimensionIDsIterable(512).parallelStream().map(id -> String.format("%d", id)).collect(Collectors.toList());
                    result.add(0, "~");
                    return result;
                }
                try {
                    victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
                }
                catch (Throwable t) {
                    return null;
                }
                return Collections.singletonList("~");
            }
            case 5: {
                if (this.isUsernameIndex(args, 0)) {
                    try {
                        victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                    return Collections.singletonList("~");
                }
                return null;
            }
        }
        return null;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        EntityPlayerMP target = null;
        if (args.length > 1 && this.isUsernameIndex(args, 0) && this.isUsernameIndex(args, 1)) {
            victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
            target = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[1]);
        } else if (args.length > 1 && this.isUsernameIndex(args, 0) && !this.isUsernameIndex(args, 1)) {
            victim = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
        } else if (args.length > 0 && this.isUsernameIndex(args, 0)) {
            victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
            target = TeleportCrossDimensionCommand.getPlayer((ICommandSender)sender, (String)args[0]);
        } else if (args.length > 0) {
            victim = TeleportCrossDimensionCommand.getCommandSenderAsPlayer((ICommandSender)sender);
        } else {
            throw new WrongUsageException("gtnh_customizer.commands.teleport_cross_dimension.error.not_enough_arguments", new Object[0]);
        }
        if (victim != null && target != null) {
            Float yawOverride = null;
            if (args.length > 2) {
                try {
                    yawOverride = Float.valueOf(CommandUtils.parseBlockRelativeFloatArgument(sender, args[2], victim.rotationYaw, false));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.sendVictimToTarget(sender, victim, target, yawOverride);
            sender.addChatMessage(new ChatComponentTranslation("gtnh_customizer.commands.teleport_cross_dimension.warning.sent_self_to_self", new Object[0]).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.GOLD).setItalic(Boolean.valueOf(true))));
            return;
        }
        if (victim != null) {
            int offset;
            Double targetBlockPosX = null;
            Double targetBlockPosY = null;
            Double targetBlockPosZ = null;
            int targetDimension = victim.dimension;
            Float yawOverride = null;
            int n = offset = this.isUsernameIndex(args, 0) ? 1 : 0;
            if (args.length > offset + 3) {
                if (args[offset + 3].startsWith("~")) {
                    if (args[offset + 3].length() > 1) {
                        throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.unknown_dimension", new Object[]{String.format("%d", args[offset + 3])});
                    }
                    targetDimension = victim.dimension;
                } else {
                    try {
                        targetDimension = Integer.parseInt(args[offset + 3], 10);
                    }
                    catch (Throwable t) {
                        throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.unknown_dimension", new Object[]{String.format("%d", args[offset + 3])});
                    }
                }
            }
            try {
                targetBlockPosX = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 0], victim.posX, !args[offset + 0].contains("."));
                targetBlockPosY = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 1], victim.posY, !args[offset + 1].contains("."));
                targetBlockPosZ = CommandUtils.parseBlockRelativeDoubleArgument(sender, args[offset + 2], victim.posZ, !args[offset + 2].contains("."));
            }
            catch (Throwable t) {
                throw new CommandException("gtnh_customizer.commands.teleport_cross_dimension.error.bad_destination", new Object[]{String.format("%.2f", args[offset + 0]), String.format("%.2f", args[offset + 1]), String.format("%.2f", args[offset + 2])});
            }
            if (args.length > offset + 4) {
                try {
                    yawOverride = Float.valueOf(CommandUtils.parseBlockRelativeFloatArgument(sender, args[offset + 4], victim.rotationYaw, false));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.sendVictimToLocation(sender, victim, targetBlockPosX, targetBlockPosY, targetBlockPosZ, targetDimension, yawOverride, Float.valueOf(victim.rotationPitch));
            return;
        }
        throw new WrongUsageException("gtnh_customizer.commands.teleport_cross_dimension.error.wrong_usage", new Object[0]);
    }

    private void sendVictimToTarget(ICommandSender sender, EntityPlayerMP victim, EntityPlayerMP target, Float yawOverride) {
        this.sendVictimToLocation(sender, victim, target.posX, target.posY, target.posZ, target.dimension, yawOverride, Float.valueOf(target.rotationPitch));
    }

    private void sendVictimToLocation(ICommandSender sender, EntityPlayerMP victim, double xPos, double yPos, double zPos, int dimension, Float yawOverride, Float pitchOverride) {
        float yaw = victim.rotationYaw;
        float pitch = victim.rotationPitch;
        if (yawOverride != null) {
            yaw = yawOverride.floatValue();
        }
        if (pitchOverride != null) {
            pitch = pitchOverride.floatValue();
        }
        this.updatePlayerLastLocation(victim);
        if (victim.dimension != dimension) {
            MinecraftServer.getServer().getConfigurationManager().transferPlayerToDimension(victim, dimension, (Teleporter)new CrossDimensionCommandTeleporter(MinecraftServer.getServer().worldServerForDimension(dimension), xPos, yPos, zPos, yaw, pitch));
        } else {
            victim.playerNetServerHandler.setPlayerLocation(xPos, yPos, zPos, yaw, pitch);
        }
        TeleportCrossDimensionCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.teleport_cross_dimension.info.teleported", (Object[])new Object[]{victim.getDisplayName(), String.format("%.2f", xPos), String.format("%.2f", yPos), String.format("%.2f", zPos), String.format("%.2f", Float.valueOf(yaw)), String.format("%.2f", Float.valueOf(pitch)), DimensionManager.getProvider((int)dimension).getDimensionName(), String.format("%d", dimension)});
    }

    private void updatePlayerLastLocation(EntityPlayerMP victim) {
        if (Loader.isModLoaded((String)"serverutilities")) {
            ServerUtilitiesPlayerData.get((ICommandSender)victim).setLastTeleport(TeleportType.VANILLA_TP, new BlockDimPos((EntityPlayer)victim));
        }
    }

    private static class CrossDimensionCommandTeleporter
    extends Teleporter {
        private double xPos;
        private double yPos;
        private double zPos;
        private float yaw;
        private float pitch;

        public CrossDimensionCommandTeleporter(WorldServer worldIn, double xPos, double yPos, double zPos, float yaw, float pitch) {
            super(worldIn);
            this.xPos = xPos;
            this.yPos = yPos;
            this.zPos = zPos;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public void placeInPortal(Entity entity, double xPos, double yPos, double zPos, float yaw) {
            entity.setLocationAndAngles(this.xPos, this.yPos, this.zPos, this.yaw, this.pitch);
            entity.motionZ = 0.0;
            entity.motionY = 0.0;
            entity.motionX = 0.0;
        }
    }
}

