/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.utils.ImmunityUtils;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityMob.class})
public class EntityMobMixin {
    @Inject(method={"findPlayerToAttack"}, at={@At(value="RETURN")}, cancellable=true)
    public void findPlayerToAttack(CallbackInfoReturnable<Entity> cir) {
        EntityMob self;
        EntityMob attacker = self = (EntityMob)this;
        Entity target = (Entity)cir.getReturnValue();
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="RETURN")}, cancellable=true)
    public void attackEntityFrom(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityMob self;
        EntityMob attacker = self = (EntityMob)this;
        Entity targetEntity = self.getEntityToAttack();
        if (targetEntity == null) {
            return;
        }
        if (!(targetEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)targetEntity;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            self.setTarget(null);
        }
    }
}

