/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.utils.ImmunityUtils;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class WorldMixin {
    @Inject(method={"getClosestVulnerablePlayerToEntity"}, at={@At(value="RETURN")}, cancellable=true)
    private void getClosestVulnerablePlayerToEntity(Entity entityIn, double distance, CallbackInfoReturnable<EntityPlayer> cir) {
        if (!(entityIn instanceof EntityLiving)) {
            return;
        }
        EntityLiving attacker = (EntityLiving)entityIn;
        EntityPlayer player = (EntityPlayer)cir.getReturnValue();
        if (player == null) {
            return;
        }
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }
}

