/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.utils;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class ImmunityUtils {
    public static boolean entityMatchesTargetingImmunity(EntityLivingBase entity, ITargetingImmunity immunity) {
        String immunityId = immunity.getEntityType();
        String rl = EntityList.getEntityString((Entity)entity);
        if (rl == null) {
            return false;
        }
        ResourceLocation entityRL = new ResourceLocation(rl);
        if (immunityId == null || immunityId.equals("")) {
            return false;
        }
        if (immunityId.equals("*")) {
            return true;
        }
        if (immunityId.contains("*")) {
            return Pattern.matches(immunityId.replace("*", "[a-zA-Z0-9_-/]+"), entityRL.toString().toLowerCase());
        }
        return entityRL.toString().toLowerCase().equals(immunityId);
    }

    public static boolean entityMatchesAnyTargetingImmunity(EntityLivingBase entity, List<ITargetingImmunity> immunityList) {
        return immunityList.stream().anyMatch(immunity -> ImmunityUtils.entityMatchesTargetingImmunity(entity, immunity));
    }
}

