package com.glektarssza.gtnh_customizer.mixins.late.serverutilities;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import com.glektarssza.gtnh_customizer.KeyBindings;

import serverutils.client.gui.GuiEditNBT;
import serverutils.client.gui.GuiEditNBT.ButtonNBT;
import serverutils.client.gui.GuiEditNBT.ButtonNBTMap;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiWrapper;

/**
 * Mixin for the {@link GuiEditNBT} class.
 */
@Mixin(GuiEditNBT.class)
public abstract class GuiEditNBTMixin extends GuiBase {
    /**
     * A shadow of the {@code shouldClose} private field.
     */
    @Shadow(remap = false)
    private int shouldClose;

    /**
     * A shadow of the {@code selected} private field.
     */
    @Shadow(remap = false)
    private ButtonNBT selected;

    /**
     * A shadow of the {@code buttonNBTRoot} private field.
     */
    @Shadow(remap = false)
    @Final
    private ButtonNBTMap buttonNBTRoot;

    /**
     * Make Java happy again.
     */
    private GuiEditNBTMixin() {
        super();
    }

    /**
     * Check whether this screen is the currently focused screen.
     *
     * @return {@code true} if this screen is the currently focused screen;
     *         {@code} false otherwise.
     */
    public boolean isFocused() {
        GuiEditNBT self = (GuiEditNBT) (Object) this;
        GuiScreen currentScreen = Minecraft.getMinecraft().currentScreen;
        return currentScreen != null && currentScreen instanceof GuiWrapper &&
            ((GuiWrapper) currentScreen).getGui() == self;
    }

    /**
     * The injection for the {@code keyPressed} method.
     *
     * @param keyCode - The key code pressed.
     * @param keyChar - The key character pressed.
     *
     * @returns {@code true} the event was handled, {@code} false otherwise.
     */
    @Override
    public boolean keyPressed(int keyCode, char keyChar) {
        if (super.keyPressed(keyCode, keyChar)) {
            return true;
        }
        if (!isFocused()) {
            return false;
        }
        GuiEditNBT self = (GuiEditNBT) (Object) this;
        GuiScreen currentScreen = Minecraft.getMinecraft().currentScreen;
        if (keyCode == KeyBindings.ACCEPT_NBT_EDITS.getKeyCode()
            || keyCode == KeyBindings.ACCEPT_NBT_EDITS_ALT.getKeyCode()) {
            shouldClose = 1;
            ((GuiWrapper) currentScreen).getGui().closeGui();
            return true;
        }
        if (keyCode == KeyBindings.CANCEL_NBT_EDITS.getKeyCode()) {
            shouldClose = 2;
            ((GuiWrapper) currentScreen).getGui().closeGui();
            return true;
        }
        if (keyCode == KeyBindings.DELETE_NBT_TAG.getKeyCode() &&
            this.selected != this.buttonNBTRoot) {
            this.selected.parent.setTag(selected.key, null);
            this.selected.parent.updateChildren(false);
            this.selected = selected.parent;
            self.panelNbt.refreshWidgets();
            self.panelTopLeft.refreshWidgets();
            return true;
        }
        return false;
    }
}
