/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.config;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.config.MigrationUtils;
import com.glektarssza.gtnh_customizer.config.v1.ConfigConstants;
import com.glektarssza.gtnh_customizer.utils.ImmutableTuple;
import com.glektarssza.gtnh_customizer.utils.exceptions.KeyAlreadyExistsException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static Configuration CONFIG_INSTANCE;
    private static final Map<String, ImmutableTuple<String, Consumer<Configuration>>> MIGRATIONS;
    private static final List<String> globallyImmunePlayers;
    private static boolean repairCommandIgnoresLiquids;
    private static boolean tconstructSlimeSaplingsBoneMealable;
    private static int extinguishCommandMaxVolume;
    private static boolean verboseLoggingEnabled;
    public static UUID CONFIG_ID;

    public static String[] getGloballyImmunePlayers() {
        String[] ret = new String[globallyImmunePlayers.size()];
        globallyImmunePlayers.toArray(ret);
        return ret;
    }

    public static void setImmunePlayers(String[] players) {
        Config.clearImmunePlayers();
        globallyImmunePlayers.addAll(Arrays.asList(players));
    }

    public static void clearImmunePlayers() {
        globallyImmunePlayers.clear();
    }

    public static boolean getTConstructSlimeSaplingBoneMealable() {
        return tconstructSlimeSaplingsBoneMealable;
    }

    public static void setTConstructSlimeSaplingBoneMealable(boolean value) {
        tconstructSlimeSaplingsBoneMealable = value;
    }

    public static void resetTConstructSlimeSaplingBoneMealable() {
        Config.setTConstructSlimeSaplingBoneMealable(false);
    }

    public static void toggleTConstructSlimeSaplingBoneMealable() {
        Config.setTConstructSlimeSaplingBoneMealable(!Config.getTConstructSlimeSaplingBoneMealable());
    }

    public static boolean getRepairCommandRaycastIgnoresLiquids() {
        return repairCommandIgnoresLiquids;
    }

    public static void setRepairCommandRaycastIgnoresLiquids(boolean value) {
        repairCommandIgnoresLiquids = value;
    }

    public static void resetRepairCommandRaycastIgnoresLiquids() {
        Config.setRepairCommandRaycastIgnoresLiquids(false);
    }

    public static void toggleRepairCommandRaycastIgnoresLiquids() {
        Config.setRepairCommandRaycastIgnoresLiquids(!Config.getRepairCommandRaycastIgnoresLiquids());
    }

    public static int getExtinguishCommandMaxVolume() {
        return extinguishCommandMaxVolume;
    }

    public static void setExtinguishCommandMaxVolume(int value) {
        extinguishCommandMaxVolume = value;
    }

    public static void resetExtinguishCommandMaxVolume() {
        Config.setExtinguishCommandMaxVolume(Integer.MAX_VALUE);
    }

    public static boolean getVerboseLoggingEnabled() {
        return verboseLoggingEnabled;
    }

    public static void setVerboseLoggingEnabled(boolean value) {
        verboseLoggingEnabled = value;
    }

    public static void resetVerboseLoggingEnabled() {
        Config.setVerboseLoggingEnabled(false);
    }

    public static void toggleVerboseLoggingEnabled() {
        Config.setVerboseLoggingEnabled(!Config.getVerboseLoggingEnabled());
    }

    public static List<ConfigCategory> getTopLevelCategories() {
        if (CONFIG_INSTANCE == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigCategory> list = new ArrayList<ConfigCategory>();
        ArrayList<String> children = new ArrayList<String>();
        for (String name : CONFIG_INSTANCE.getCategoryNames()) {
            if (Config.CONFIG_INSTANCE.getCategory((String)name).parent != null) continue;
            children.add(name);
        }
        for (String category : children) {
            if (category.contains(".")) continue;
            list.add(CONFIG_INSTANCE.getCategory(category));
        }
        return list;
    }

    public static void init(File configDir, String fileName) throws KeyAlreadyExistsException, NoSuchElementException {
        Config.registerMigration("1", "2", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH)) {
                MigrationUtils.renameProperty(configInstance, ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH, "globallyImmunePlayers");
            }
        });
        Config.registerMigration("2", "3", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, com.glektarssza.gtnh_customizer.config.v2.ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH)) {
                MigrationUtils.renameProperty(configInstance, com.glektarssza.gtnh_customizer.config.v2.ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH, "globally_immune_players");
            }
        });
        Config.registerMigration("5", "6", configInstance -> {
            if (MigrationUtils.hasPropertyByPath(configInstance, com.glektarssza.gtnh_customizer.config.v5.ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH)) {
                configInstance.setCategoryComment("gameplay", "Gameplay-related tweaks").setCategoryLanguageKey("gameplay", com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_LANG_KEY).setCategoryRequiresMcRestart("gameplay", false).setCategoryRequiresMcRestart("gameplay", false);
                MigrationUtils.moveProperty(configInstance, com.glektarssza.gtnh_customizer.config.v5.ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_PATH, "gameplay");
                if (configInstance.getCategory("general").isEmpty()) {
                    configInstance.removeCategory(configInstance.getCategory("general"));
                }
            }
            if (MigrationUtils.hasPropertyByPath(configInstance, com.glektarssza.gtnh_customizer.config.v5.ConfigConstants.PROPERTY_REPAIR_COMMAND_IGNORES_LIQUIDS_PATH)) {
                MigrationUtils.renameProperty(configInstance, com.glektarssza.gtnh_customizer.config.v5.ConfigConstants.PROPERTY_REPAIR_COMMAND_IGNORES_LIQUIDS_PATH, "repair_raycast_ignores_liquids");
            }
        });
        if (CONFIG_INSTANCE != null) {
            return;
        }
        CONFIG_INSTANCE = new Configuration(new File(configDir, fileName), "6");
    }

    public static void load() {
        if (CONFIG_INSTANCE == null) {
            GTNHCustomizer.LOGGER.error("Cannot load configuration!");
            GTNHCustomizer.LOGGER.error("Configuration has not been initialized yet!");
            return;
        }
        CONFIG_INSTANCE.load();
        if (!CONFIG_INSTANCE.getLoadedConfigVersion().equals("6")) {
            GTNHCustomizer.LOGGER.warn("Your configuration is out of date!");
            GTNHCustomizer.LOGGER.warn("We're running version '{}' but you have version '{}'", new Object[]{"6", CONFIG_INSTANCE.getLoadedConfigVersion()});
            GTNHCustomizer.LOGGER.warn("Attempting to migrate!");
            try {
                Config.applyConfigMigrations(CONFIG_INSTANCE.getLoadedConfigVersion(), "6", CONFIG_INSTANCE);
                Config.save();
            }
            catch (NoSuchElementException t) {
                GTNHCustomizer.LOGGER.info("No migrations available from version '{}' to version '{}', assuming migration is not required!", new Object[]{CONFIG_INSTANCE.getLoadedConfigVersion(), "6"});
            }
            catch (Throwable t) {
                GTNHCustomizer.LOGGER.warn("Could not migrate configuration from version '{}' to version '{}'!", new Object[]{CONFIG_INSTANCE.getLoadedConfigVersion(), "6"});
                GTNHCustomizer.LOGGER.warn("Here's a stack trace for you to use if you want to file a bug report about migrations failing:");
                GTNHCustomizer.LOGGER.warn((Object)t);
                GTNHCustomizer.LOGGER.warn("Any customizations you've made are probably about to get nuked!");
                File backupLocation = new File(String.format("%s.bak", CONFIG_INSTANCE.getConfigFile().getAbsolutePath()));
                GTNHCustomizer.LOGGER.warn("Copying your current configuration into '{}' as a backup...", new Object[]{backupLocation.getAbsolutePath()});
                try {
                    Files.copy(CONFIG_INSTANCE.getConfigFile().toPath(), backupLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable tt) {
                    GTNHCustomizer.LOGGER.warn("Failed to generate a backup of your current configuration!");
                    GTNHCustomizer.LOGGER.warn("Here's a stack trace for you to use if you want to diagnose what happened:");
                    GTNHCustomizer.LOGGER.warn((Object)tt);
                    GTNHCustomizer.LOGGER.warn("Please do NOT file a bug report about failing to create a backup, this is almost certainly NOT the mod developer's fault!");
                    GTNHCustomizer.LOGGER.warn("Proceeding anyway, sorry!");
                }
                CONFIG_INSTANCE.getCategoryNames().stream().forEach(categoryName -> CONFIG_INSTANCE.removeCategory(CONFIG_INSTANCE.getCategory(categoryName)));
            }
        }
        CONFIG_INSTANCE.setCategoryComment("gameplay", "Gameplay-related tweaks").setCategoryLanguageKey("gameplay", com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_LANG_KEY).setCategoryRequiresMcRestart("gameplay", false).setCategoryRequiresMcRestart("gameplay", false);
        Config.setImmunePlayers(CONFIG_INSTANCE.get("gameplay", "globally_immune_players", new String[0], "A list of players who are globally immune to being targeted.").setLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.PROPERTY_GLOBALLY_IMMUNE_PLAYERS_LANG_KEY).setRequiresMcRestart(false).setRequiresWorldRestart(false).getStringList());
        CONFIG_INSTANCE.setCategoryComment(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_PATH, "Tinker's Construct gameplay-related tweaks").setCategoryLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_PATH, com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_LANG_KEY).setCategoryRequiresMcRestart(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_PATH, false).setCategoryRequiresMcRestart(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_PATH, false);
        Config.setTConstructSlimeSaplingBoneMealable(CONFIG_INSTANCE.get(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_GAMEPLAY_TCONSTRUCT_PATH, "slime_sapling_bone_mealable", true, "Whether to allow Tinker's Construct Slime Saplings to be bone mealed.").setLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.PROPERTY_TCONSTRUCT_SLIME_SAPLING_BONE_MEALABLE_LANG_KEY).setRequiresMcRestart(false).setRequiresWorldRestart(false).getBoolean());
        CONFIG_INSTANCE.setCategoryComment("command", "Command settings").setCategoryLanguageKey("command", com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_COMMAND_LANG_KEY).setCategoryRequiresMcRestart("command", false).setCategoryRequiresMcRestart("command", false);
        Config.setRepairCommandRaycastIgnoresLiquids(CONFIG_INSTANCE.get("command", "repair_raycast_ignores_liquids", false, "Whether the 'repair' command ignores liquids when raycasting to look for containers to repair items inside of.").setLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.PROPERTY_REPAIR_COMMAND_RAYCAST_IGNORES_LIQUIDS_LANG_KEY).setRequiresMcRestart(false).setRequiresWorldRestart(false).getBoolean());
        Config.setExtinguishCommandMaxVolume(CONFIG_INSTANCE.get("command", "extinguish_max_volume", Integer.MAX_VALUE, "The maximum number of blocks the 'extinguish' command will process.").setLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.PROPERTY_EXTINGUISH_COMMAND_MAX_VOLUME_LANG_KEY).setRequiresMcRestart(false).setRequiresWorldRestart(false).getInt());
        CONFIG_INSTANCE.setCategoryComment("debugging", "Debugging settings").setCategoryLanguageKey("debugging", com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.CATEGORY_DEBUGGING_LANG_KEY).setCategoryRequiresMcRestart("debugging", false).setCategoryRequiresMcRestart("debugging", false);
        Config.setVerboseLoggingEnabled(CONFIG_INSTANCE.get("debugging", "verbose_logging", false, "Enable verbose logging.").setLanguageKey(com.glektarssza.gtnh_customizer.config.v6.ConfigConstants.PROPERTY_DEBUG_LOGGING_LANG_KEY).setRequiresMcRestart(false).setRequiresWorldRestart(false).getBoolean());
    }

    public static void save() {
        if (CONFIG_INSTANCE == null) {
            GTNHCustomizer.LOGGER.error("Cannot save configuration!");
            GTNHCustomizer.LOGGER.error("Configuration has not been initialized yet!");
            return;
        }
        if (CONFIG_INSTANCE.hasChanged()) {
            CONFIG_INSTANCE.save();
        }
    }

    public static void sync() {
        Config.save();
        Config.load();
    }

    private static void applyConfigMigrations(String fromVersion, String toVersion, Configuration configInstance) throws NoSuchElementException {
        LinkedList<ImmutableTuple<String, Consumer<Configuration>>> migrators = new LinkedList<ImmutableTuple<String, Consumer<Configuration>>>();
        HashSet<String> alreadyMigratedVersions = new HashSet<String>();
        while (MIGRATIONS.containsKey(fromVersion) && !alreadyMigratedVersions.contains(fromVersion) && !toVersion.equals(fromVersion)) {
            migrators.push(MIGRATIONS.get(fromVersion));
            alreadyMigratedVersions.add(fromVersion);
            fromVersion = (String)((ImmutableTuple)migrators.peekLast()).getFirst();
        }
        if (alreadyMigratedVersions.contains(fromVersion)) {
            throw new RuntimeException("Cyclic migration detected!");
        }
        if (!toVersion.equals(fromVersion)) {
            throw new NoSuchElementException(String.format("No available migration route from configuration version '%s' to configuration version '%s'!", fromVersion, toVersion));
        }
        Configuration currentVersion = MigrationUtils.cloneConfiguration(CONFIG_INSTANCE);
        for (ImmutableTuple immutableTuple : migrators) {
            ((Consumer)immutableTuple.getSecond()).accept(currentVersion);
        }
        CONFIG_INSTANCE = currentVersion;
    }

    private static void registerMigration(String fromVersion, String toVersion, Consumer<Configuration> migrator) throws KeyAlreadyExistsException {
        if (MIGRATIONS.containsKey(String.format("%s:%s", fromVersion, toVersion))) {
            throw new KeyAlreadyExistsException(String.format("Migration already exists from configuration '%s' version to configuration version '%s'", fromVersion, toVersion));
        }
        MIGRATIONS.put(fromVersion, new ImmutableTuple<String, Consumer<Configuration>>(toVersion, migrator));
    }

    static {
        MIGRATIONS = new HashMap<String, ImmutableTuple<String, Consumer<Configuration>>>();
        globallyImmunePlayers = new ArrayList<String>();
        repairCommandIgnoresLiquids = false;
        tconstructSlimeSaplingsBoneMealable = true;
        extinguishCommandMaxVolume = Integer.MAX_VALUE;
        verboseLoggingEnabled = false;
        CONFIG_ID = UUID.randomUUID();
    }
}

