/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.utils.ImmunityUtils;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityEnderman.class})
public class EntityEndermanMixin {
    @Inject(method={"findPlayerToAttack"}, at={@At(value="RETURN")}, cancellable=true)
    public void findPlayerToAttack(CallbackInfoReturnable<Entity> cir) {
        EntityEnderman self;
        EntityEnderman attacker = self = (EntityEnderman)this;
        Entity returnValue = (Entity)cir.getReturnValue();
        EntityPlayer player = null;
        if (returnValue instanceof EntityPlayer) {
            player = (EntityPlayer)returnValue;
        }
        if (player == null) {
            return;
        }
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"shouldAttackPlayer"}, at={@At(value="RETURN")}, cancellable=true)
    public void shouldAttackPlayer(EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        EntityEnderman self;
        EntityEnderman attacker = self = (EntityEnderman)this;
        if (player == null) {
            return;
        }
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue((Object)false);
        }
    }
}

