/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer;

import com.glektarssza.gtnh_customizer.commands.ExtinguishCommand;
import com.glektarssza.gtnh_customizer.commands.ListDimensionsCommand;
import com.glektarssza.gtnh_customizer.commands.RepairCommand;
import com.glektarssza.gtnh_customizer.commands.TeleportCrossDimensionCommand;
import com.glektarssza.gtnh_customizer.config.Config;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import org.apache.logging.log4j.Logger;
import serverutils.events.ServerUtilitiesPreInitRegistryEvent;
import thaumcraft.common.blocks.BlockCustomPlant;

@Mod(modid="gtnh_customizer", name="Gregtech: New Horizons Customizer", version="v0.9.0", dependencies="", acceptableRemoteVersions="*", guiFactory="com.glektarssza.gtnh_customizer.config.GuiFactory")
public class GTNHCustomizer {
    private static File configDir;
    public static Logger LOGGER;
    public static final int WARNING_EMIT_LIMIT = 20;
    public static final Map<String, Integer> WARNING_LIMIT_TRACKER;
    @Mod.Instance
    public static GTNHCustomizer instance;

    public static boolean shouldEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        return WARNING_LIMIT_TRACKER.get(category) > 0;
    }

    public static void trackEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        int limit = WARNING_LIMIT_TRACKER.compute(category, (_k, v) -> v - 1);
        if (limit <= 0) {
            LOGGER.warn(String.format("Too many identical warnings logged for category \"%s\"! Silencing further warnings on this issue!", category));
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        LOGGER.info("Pre-initializing {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        configDir = event.getModConfigurationDirectory();
        Config.init(configDir, String.format("%s.cfg", "gtnh_customizer"));
        LOGGER.info("Synchronizing configuration for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        Config.sync();
        LOGGER.info("Registering mod {} with the Forge event bus...", new Object[]{"Gregtech: New Horizons Customizer"});
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        LOGGER.info("Done pre-initializing {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        LOGGER.info("Initializing {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        LOGGER.info("Done initializing {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("Handling server about to start...");
        LOGGER.info("Registering custom commands...");
        event.registerServerCommand((ICommand)new TeleportCrossDimensionCommand());
        event.registerServerCommand((ICommand)new ListDimensionsCommand());
        event.registerServerCommand((ICommand)new RepairCommand());
        event.registerServerCommand((ICommand)new ExtinguishCommand());
        LOGGER.info("Done registering custom commands!");
        LOGGER.info("Done handling server about to start!");
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.configID.equalsIgnoreCase(Config.CONFIG_ID.toString())) {
            LOGGER.info("Synchronizing configuration for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
            Config.sync();
        }
    }

    @SubscribeEvent
    public void onServerUtilitiesPreInitRegistry(ServerUtilitiesPreInitRegistryEvent event) {
        event.getRegistry().registerServerReloadHandler(new ResourceLocation("gtnh_customizer", "config"), reloadEvent -> {
            try {
                Config.sync();
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        });
    }

    @SubscribeEvent
    public void onBoneMeal(BonemealEvent event) {
        if (!Loader.isModLoaded((String)"Thaumcraft")) {
            return;
        }
        if (!(event.block instanceof BlockCustomPlant)) {
            return;
        }
        if (event.world.getBlockLightValue(event.x, event.y, event.z) < 9) {
            return;
        }
        switch (event.world.getBlockMetadata(event.x, event.y, event.z)) {
            case 0: {
                if (!Config.getThaumcraftCanBoneMealGreatwoodSaplings()) {
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                if (event.world.isRemote || (double)event.world.rand.nextFloat() >= 0.45) {
                    return;
                }
                ((BlockCustomPlant)event.block).growGreatTree(event.world, event.x, event.y, event.z, event.world.rand);
                break;
            }
            case 1: {
                if (!Config.getThaumcraftCanBoneMealSilverwoodSaplings()) {
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                if (event.world.isRemote || (double)event.world.rand.nextFloat() >= 0.45) {
                    return;
                }
                ((BlockCustomPlant)event.block).growSilverTree(event.world, event.x, event.y, event.z, event.world.rand);
            }
        }
    }

    static {
        WARNING_LIMIT_TRACKER = new HashMap<String, Integer>();
    }
}

