/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.api.immunity;

import com.glektarssza.gtnh_customizer.api.immunity.IPhysicalImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.ImmunityType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public interface IDamageImmunity
extends IPhysicalImmunity {
    @Override
    default public ImmunityType getImmunityType() {
        return ImmunityType.Damage;
    }

    @Override
    default public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagString immunityType = ImmunityType.toNBTString(this.getImmunityType());
        String entityType = null;
        if (immunityType == null) {
            return nbt;
        }
        if (this.hasEntityType()) {
            entityType = this.getEntityType();
        }
        nbt.setTag("immunityType", (NBTBase)immunityType);
        nbt.setString("damageType", this.getDamageType());
        if (entityType != null) {
            nbt.setString("entityType", entityType);
        }
        nbt.setBoolean("appliesToDirect", this.getAppliesToDirectDamage());
        nbt.setBoolean("appliesToIndirect", this.getAppliesToIndirectDamage());
        return nbt;
    }

    @Override
    default public void deserializeNBT(NBTTagCompound nbt) {
        if (!nbt.hasKey("immunityType", 8)) {
            return;
        }
        ImmunityType type = ImmunityType.fromNBTString((NBTTagString)nbt.getTag("immunityType"));
        if (type != ImmunityType.Damage) {
            return;
        }
        if (!nbt.hasKey("damageType", 8)) {
            return;
        }
        this.setDamageType(nbt.getString("damageType"));
        if (nbt.hasKey("entityType", 8)) {
            this.setEntityType(nbt.getString("entityType"));
        } else {
            this.setEntityType(null);
        }
        if (nbt.hasKey("appliesToDirect", 99)) {
            this.setAppliesToDirectDamage(nbt.getBoolean("appliesToDirect"));
        } else {
            this.setAppliesToDirectDamage(false);
        }
        if (nbt.hasKey("appliesToIndirect", 99)) {
            this.setAppliesToDirectDamage(nbt.getBoolean("appliesToIndirect"));
        } else {
            this.setAppliesToDirectDamage(false);
        }
    }
}

