/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import com.glektarssza.gtnh_customizer.utils.ImmutableTuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;

public class ListDimensionsCommand
extends CommandBase {
    public String getCommandName() {
        return "list-dimensions";
    }

    public List<String> getCommandAliases() {
        return Collections.emptyList();
    }

    public String getCommandUsage(ICommandSender sender) {
        return "gtnh_customizer.commands.list_dimensions.usage";
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    public void processCommand(ICommandSender sender, String[] args) {
        Integer limit = null;
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            try {
                limit = Integer.parseInt(args[0], 10);
                continue;
            }
            catch (Throwable t) {
                filters.add(args[i]);
            }
        }
        if (limit == null) {
            limit = 512;
        }
        if (limit < 0) {
            throw new CommandException("gtnh_customizer.commands.list_dimensions.error.invalid_limit", new Object[]{limit});
        }
        Stream<ImmutableTuple> dimensionStream = CommandUtils.getAllDimensionIDsIterable().parallelStream().map(id -> new ImmutableTuple<Integer, String>((Integer)id, DimensionManager.getProvider((int)id).getDimensionName()));
        if (filters.size() > 0) {
            dimensionStream = dimensionStream.filter(tuple -> filters.stream().anyMatch(filter -> ((String)tuple.getSecond()).toLowerCase().contains(filter.toLowerCase())));
        }
        List dimensions = dimensionStream.limit(limit.intValue()).collect(Collectors.toList());
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation("gtnh_customizer.commands.list_dimensions.info.header", new Object[0]));
        for (int i = 0; i < dimensions.size(); ++i) {
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("gtnh_customizer.commands.list_dimensions.info.entry", new Object[]{((ImmutableTuple)dimensions.get(i)).getFirst(), ((ImmutableTuple)dimensions.get(i)).getSecond()}));
        }
    }
}

