/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.late.thaumcraft;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.utils.ImmunityUtils;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import thaumcraft.common.entities.monster.EntityWisp;

@Mixin(value={EntityWisp.class})
public class EntityWispMixin {
    @Shadow(remap=false)
    private Entity targetedEntity;

    @Inject(method={"attackEntityFrom"}, at={@At(value="FIELD", target="Lthaumcraft/common/entities/monster/EntityWisp;targetedEntity:Lnet/minecraft/entity/Entity;", opcode=181, shift=At.Shift.AFTER, remap=false)}, cancellable=true)
    public void overrideTargetedEntity(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityWisp self;
        EntityWisp attacker = self = (EntityWisp)this;
        if (this.targetedEntity == null) {
            return;
        }
        if (!(this.targetedEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)this.targetedEntity;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            this.targetedEntity = null;
        }
    }

    @Inject(method={"updateEntityActionState"}, at={@At(value="FIELD", target="Lthaumcraft/common/entities/monster/EntityWisp;targetedEntity:Lnet/minecraft/entity/Entity;", opcode=181, shift=At.Shift.AFTER, remap=false)}, cancellable=true)
    public void overrideTargetedEntity(CallbackInfo ci) {
        EntityWisp self;
        EntityWisp attacker = self = (EntityWisp)this;
        if (this.targetedEntity == null) {
            return;
        }
        if (!(this.targetedEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)this.targetedEntity;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            this.targetedEntity = null;
        }
    }
}

