/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.utils;

import com.glektarssza.gtnh_customizer.api.immunity.IDamageImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.IHurtImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.IImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.IKnockbackImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.api.immunity.ImmunityType;
import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.impl.immunity.DamageImmunity;
import com.glektarssza.gtnh_customizer.impl.immunity.HurtImmunity;
import com.glektarssza.gtnh_customizer.impl.immunity.KnockbackImmunity;
import com.glektarssza.gtnh_customizer.impl.immunity.TargetingImmunity;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class PlayerUtils {
    public static boolean getIsPlayerGloballyImmune(EntityPlayer player) {
        GameProfile playerProfile = player.getGameProfile();
        UUID playerUUID = playerProfile == null ? null : EntityPlayer.func_146094_a((GameProfile)playerProfile);
        return Arrays.asList(Config.getGloballyImmunePlayers()).stream().anyMatch(item -> playerUUID != null && item.equalsIgnoreCase(playerUUID.toString()) || item.equalsIgnoreCase(player.getDisplayName()));
    }

    public static NBTTagCompound getPlayerModData(EntityPlayer player) {
        NBTTagCompound playerData = player.getEntityData();
        if (!playerData.hasKey("gtnh_customizer", 10)) {
            return new NBTTagCompound();
        }
        return (NBTTagCompound)playerData.getTag("gtnh_customizer");
    }

    public static List<IImmunity<NBTTagCompound>> getPlayerImmunities(EntityPlayer player) {
        NBTTagCompound playerData = PlayerUtils.getPlayerModData(player);
        if (!playerData.hasKey("immunities", 9)) {
            return Collections.emptyList();
        }
        NBTTagList nbtImmunityList = playerData.getTagList("immunities", 10);
        if (nbtImmunityList.tagCount() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IImmunity<NBTTagCompound>> results = new ArrayList<IImmunity<NBTTagCompound>>();
        block6: for (int i = 0; i < nbtImmunityList.tagCount(); ++i) {
            IImmunity<NBTTagCompound> item;
            ImmunityType type;
            NBTTagCompound nbtItem;
            NBTTagCompound nbtBaseItem = nbtImmunityList.getCompoundTagAt(i);
            if (!(nbtBaseItem instanceof NBTTagCompound) || !(nbtItem = nbtBaseItem).hasKey("immunityType", 8) || (type = ImmunityType.fromNBTString((NBTTagString)nbtItem.getTag("immunityType"))) == null) continue;
            switch (type) {
                case Damage: {
                    item = new DamageImmunity();
                    break;
                }
                case Hurt: {
                    item = new HurtImmunity();
                    break;
                }
                case Knockback: {
                    item = new KnockbackImmunity();
                    break;
                }
                case Targeting: {
                    item = new TargetingImmunity();
                    break;
                }
                default: {
                    continue block6;
                }
            }
            item.deserializeNBT(nbtItem);
            results.add(item);
        }
        return results;
    }

    public static List<IDamageImmunity> getPlayerDamageImmunities(EntityPlayer player) {
        return PlayerUtils.getPlayerImmunities(player).stream().filter(item -> item.getImmunityType() == ImmunityType.Damage).map(item -> (IDamageImmunity)item).collect(Collectors.toList());
    }

    public static List<IHurtImmunity> getPlayerHurtImmunities(EntityPlayer player) {
        return PlayerUtils.getPlayerImmunities(player).stream().filter(item -> item.getImmunityType() == ImmunityType.Hurt).map(item -> (IHurtImmunity)item).collect(Collectors.toList());
    }

    public static List<IKnockbackImmunity> getPlayerKnockbackImmunities(EntityPlayer player) {
        return PlayerUtils.getPlayerImmunities(player).stream().filter(item -> item.getImmunityType() == ImmunityType.Knockback).map(item -> (IKnockbackImmunity)item).collect(Collectors.toList());
    }

    public static List<ITargetingImmunity> getPlayerTargetingImmunities(EntityPlayer player) {
        return PlayerUtils.getPlayerImmunities(player).stream().filter(item -> item.getImmunityType() == ImmunityType.Targeting).map(item -> (ITargetingImmunity)item).collect(Collectors.toList());
    }
}

